/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.xgboost.ObjFunction;

public abstract class Classification
extends ObjFunction {
    private List<String> targetCategories = null;

    public Classification(int num_class) {
        super(OpType.CATEGORICAL, DataType.STRING);
        this.setTargetCategories(Classification.createTargetCategories(num_class));
    }

    public void updateTargetCategories(List<String> targetCategories) {
        if (this.targetCategories != null && this.targetCategories.size() != targetCategories.size()) {
            throw new IllegalArgumentException();
        }
        this.targetCategories = targetCategories;
    }

    public List<String> getTargetCategories() {
        return this.targetCategories;
    }

    private void setTargetCategories(List<String> targetCategories) {
        this.targetCategories = targetCategories;
    }

    private static List<String> createTargetCategories(int size) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            result.add(String.valueOf(i));
        }
        return result;
    }
}

