/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import java.math.BigDecimal;
import java.math.MathContext;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.jpmml.converter.ValueUtil;
import org.jpmml.xgboost.Feature;
import org.jpmml.xgboost.Node;

public class ContinuousFeature
extends Feature {
    public ContinuousFeature(DataField dataField) {
        super(dataField);
    }

    @Override
    public boolean isDefaultLeft(Node node) {
        return node.default_left();
    }

    @Override
    public Predicate encodePredicate(int splitCondition, boolean left) {
        Number value = this.encodeValue(splitCondition);
        SimplePredicate simplePredicate = new SimplePredicate().setField(this.getName()).setOperator(left ? SimplePredicate.Operator.LESS_THAN : SimplePredicate.Operator.GREATER_OR_EQUAL).setValue(ValueUtil.formatValue((Number)value));
        return simplePredicate;
    }

    private Number encodeValue(int splitCondition) {
        DataField dataField = this.getDataField();
        float value = Float.intBitsToFloat(splitCondition);
        DataType dataType = dataField.getDataType();
        switch (dataType) {
            case INTEGER: {
                return this.encodeIntegerValue(value);
            }
        }
        return this.encodeFloatValue(value);
    }

    private Number encodeIntegerValue(float value) {
        Integer result = (int)(value + 1.0f);
        return result;
    }

    private Number encodeFloatValue(float value) {
        BigDecimal result = new BigDecimal(value, MathContext.DECIMAL32);
        return result;
    }
}

