/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import com.google.common.collect.Lists;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningModel;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.Segmentation;
import org.jpmml.converter.MiningModelUtil;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.xgboost.Classification;
import org.jpmml.xgboost.FeatureMap;

public class LogisticClassification
extends Classification {
    public LogisticClassification() {
        super(2);
    }

    @Override
    public MiningModel encodeMiningModel(Segmentation segmentation, float base_score, FeatureMap featureMap) {
        FieldName xgbField;
        Output output;
        DataField dataField = this.getDataField();
        FieldName targetField = dataField.getName();
        List activeFields = PMMLUtil.getNames(featureMap.getDataFields());
        MiningSchema miningSchema = ModelUtil.createMiningSchema(null, (List)activeFields);
        if (!ValueUtil.isZero((Number)Float.valueOf(base_score))) {
            OutputField rawXgbValue = LogisticClassification.createPredictedField(FieldName.create((String)"rawXgbValue"));
            Apply expression = PMMLUtil.createApply((String)"+", (Expression[])new Expression[]{new FieldRef(rawXgbValue.getName()), PMMLUtil.createConstant((Object)Float.valueOf(base_score))});
            OutputField scaledXgbValue = LogisticClassification.createTransformedField(FieldName.create((String)"scaledXgbValue"), (Expression)expression);
            output = new Output().addOutputFields(new OutputField[]{rawXgbValue, scaledXgbValue});
            xgbField = scaledXgbValue.getName();
        } else {
            OutputField xgbValue = LogisticClassification.createPredictedField(FieldName.create((String)"xgbValue"));
            output = new Output().addOutputFields(new OutputField[]{xgbValue});
            xgbField = xgbValue.getName();
        }
        MiningModel miningModel = new MiningModel(MiningFunctionType.REGRESSION, miningSchema).setSegmentation(segmentation).setOutput(output);
        return MiningModelUtil.createBinaryLogisticClassification((FieldName)targetField, (List)Lists.reverse(this.getTargetCategories()), (List)activeFields, (Model)miningModel, (FieldName)xgbField, (double)-1.0, (boolean)true);
    }
}

