/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.MissingValueStrategyType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.TreeModel;
import org.dmg.pmml.True;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.xgboost.Feature;
import org.jpmml.xgboost.FeatureMap;
import org.jpmml.xgboost.Node;
import org.jpmml.xgboost.NodeStat;
import org.jpmml.xgboost.XGBoostDataInput;

public class RegTree {
    private int num_roots;
    private int num_nodes;
    private int num_deleted;
    private int max_depth;
    private int num_feature;
    private int size_leaf_vector;
    private List<Node> nodes;
    private List<NodeStat> stats;

    public void load(XGBoostDataInput input) throws IOException {
        int i;
        this.num_roots = input.readInt();
        this.num_nodes = input.readInt();
        this.num_deleted = input.readInt();
        this.max_depth = input.readInt();
        this.num_feature = input.readInt();
        this.size_leaf_vector = input.readInt();
        input.readReserved(31);
        this.nodes = new ArrayList<Node>();
        for (i = 0; i < this.num_nodes; ++i) {
            Node node = new Node();
            node.load(input);
            this.nodes.add(node);
        }
        this.stats = new ArrayList<NodeStat>();
        for (i = 0; i < this.num_nodes; ++i) {
            NodeStat stat = new NodeStat();
            stat.load(input);
            this.stats.add(stat);
        }
    }

    public TreeModel encodeTreeModel(FeatureMap featureMap) {
        org.dmg.pmml.Node root = new org.dmg.pmml.Node().setPredicate((Predicate)new True());
        this.encodeNode(root, 0, featureMap);
        MiningSchema miningSchema = ModelUtil.createMiningSchema(null, featureMap.getDataFields(), (PMMLObject)root);
        TreeModel treeModel = new TreeModel(MiningFunctionType.REGRESSION, miningSchema, root).setSplitCharacteristic(TreeModel.SplitCharacteristic.BINARY_SPLIT).setMissingValueStrategy(MissingValueStrategyType.DEFAULT_CHILD);
        return treeModel;
    }

    private void encodeNode(org.dmg.pmml.Node parent, int index, FeatureMap featureMap) {
        parent.setId(String.valueOf(index + 1));
        Node node = this.nodes.get(index);
        if (!node.is_leaf()) {
            int splitIndex = node.split_index();
            Feature feature = featureMap.getFeature(splitIndex);
            int splitCondition = node.split_cond();
            org.dmg.pmml.Node leftChild = new org.dmg.pmml.Node().setPredicate(feature.encodePredicate(splitCondition, true));
            this.encodeNode(leftChild, node.cleft(), featureMap);
            org.dmg.pmml.Node rightChild = new org.dmg.pmml.Node().setPredicate(feature.encodePredicate(splitCondition, false));
            parent.addNodes(new org.dmg.pmml.Node[]{leftChild, rightChild});
            this.encodeNode(rightChild, node.cright(), featureMap);
            boolean defaultLeft = feature.isDefaultLeft(node);
            parent.setDefaultChild(defaultLeft ? leftChild.getId() : rightChild.getId());
        } else {
            BigDecimal score = new BigDecimal(node.leaf_value(), MathContext.DECIMAL32);
            parent.setScore(ValueUtil.formatValue((Number)score));
        }
    }
}

