/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import com.google.common.io.ByteStreams;
import com.google.common.io.LittleEndianDataInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;

public class XGBoostDataInput
implements Closeable {
    private LittleEndianDataInputStream dis = null;
    private static final byte[] BINF_MAGIC = new byte[]{98, 105, 110, 102};

    public XGBoostDataInput(InputStream is) throws IOException {
        this.dis = new LittleEndianDataInputStream(XGBoostDataInput.init(new PushbackInputStream(is, 4)));
    }

    @Override
    public void close() throws IOException {
        this.dis.close();
    }

    public int readInt() throws IOException {
        return this.dis.readInt();
    }

    public float readFloat() throws IOException {
        return this.dis.readFloat();
    }

    public String readString() throws IOException {
        int length = (int)this.dis.readLong();
        byte[] buffer = new byte[length];
        ByteStreams.readFully((InputStream)this.dis, (byte[])buffer);
        return new String(buffer);
    }

    public void readReserved(int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            int value = this.dis.readInt();
            if (value == 0) continue;
            throw new IOException();
        }
    }

    private static InputStream init(PushbackInputStream is) throws IOException {
        byte[] header = new byte[4];
        ByteStreams.readFully((InputStream)is, (byte[])header);
        if (!Arrays.equals(BINF_MAGIC, header)) {
            is.unread(header);
        }
        return is;
    }
}

