/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import org.dmg.pmml.Apply;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningModel;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.Segmentation;
import org.jpmml.converter.MiningModelUtil;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.Schema;
import org.jpmml.xgboost.Regression;

public class PoissonRegression
extends Regression {
    @Override
    public MiningModel encodeMiningModel(Segmentation segmentation, float base_score, Schema schema) {
        Schema segmentSchema = schema.toAnonymousSchema();
        Output output = PoissonRegression.encodeOutput(base_score);
        MiningModel miningModel = new MiningModel(MiningFunctionType.REGRESSION, ModelUtil.createMiningSchema((Schema)segmentSchema)).setSegmentation(segmentation).setOutput(output);
        return MiningModelUtil.createRegression((Schema)schema, (Model)miningModel);
    }

    private static Output encodeOutput(float base_score) {
        Output output = new Output();
        OutputField xgbValue = PoissonRegression.createPredictedField(output, base_score);
        Apply expression = PMMLUtil.createApply((String)"exp", (Expression[])new Expression[]{new FieldRef(xgbValue.getName())});
        OutputField transformedValue = PoissonRegression.createTransformedField(FieldName.create((String)"transformedValue"), (Expression)expression);
        output.addOutputFields(new OutputField[]{transformedValue});
        return output;
    }
}

