/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.Schema;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.xgboost.ObjFunction;
import org.jpmml.xgboost.RegTree;
import org.jpmml.xgboost.XGBoostDataInput;

public class GBTree {
    private int num_trees;
    private int num_roots;
    private int num_feature;
    private int num_output_group;
    private int size_leaf_vector;
    private List<RegTree> trees;
    private int[] tree_info;

    public void load(XGBoostDataInput input) throws IOException {
        int i;
        this.num_trees = input.readInt();
        this.num_roots = input.readInt();
        this.num_feature = input.readInt();
        input.readReserved(3);
        this.num_output_group = input.readInt();
        this.size_leaf_vector = input.readInt();
        input.readReserved(32);
        this.trees = new ArrayList<RegTree>();
        for (i = 0; i < this.num_trees; ++i) {
            RegTree tree = new RegTree();
            tree.load(input);
            this.trees.add(tree);
        }
        this.tree_info = new int[this.num_trees];
        for (i = 0; i < this.num_trees; ++i) {
            this.tree_info[i] = input.readInt();
        }
    }

    public MiningModel encodeMiningModel(ObjFunction obj, float base_score, Schema schema) {
        ArrayList<TreeModel> treeModels = new ArrayList<TreeModel>();
        Schema segmentSchema = schema.toAnonymousSchema();
        for (int i = 0; i < this.trees.size(); ++i) {
            RegTree tree = this.trees.get(i);
            TreeModel treeModel = tree.encodeTreeModel(segmentSchema);
            treeModels.add(treeModel);
        }
        Segmentation segmentation = MiningModelUtil.createSegmentation((Segmentation.MultipleModelMethod)Segmentation.MultipleModelMethod.SUM, treeModels);
        return obj.encodeMiningModel(segmentation, base_score, schema);
    }

    public List<RegTree> getTrees() {
        return this.trees;
    }
}

