/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.regression.RegressionModel;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.xgboost.Classification;
import org.jpmml.xgboost.ObjFunction;

public class SoftMaxClassification
extends Classification {
    private static final ObjFunction.Transformation TRANSFORMATION = new ObjFunction.Transformation(){

        @Override
        public Expression createExpression(FieldName name) {
            return PMMLUtil.createApply((String)"exp", (Expression[])new Expression[]{new FieldRef(name)});
        }
    };

    public SoftMaxClassification(int num_class) {
        super(num_class);
        if (num_class < 3) {
            throw new IllegalArgumentException("Multi-class classification requires three or more target categories");
        }
    }

    @Override
    public MiningModel encodeMiningModel(Segmentation segmentation, float base_score, Schema schema) {
        Schema segmentSchema = schema.toAnonymousSchema();
        List segments = segmentation.getSegments();
        ArrayList<MiningModel> models = new ArrayList<MiningModel>();
        List targetCategories = schema.getTargetCategories();
        for (int i = 0; i < targetCategories.size(); ++i) {
            String targetCategory = (String)targetCategories.get(i);
            List valueSegments = SoftMaxClassification.getColumn(segments, i, segments.size() / targetCategories.size(), targetCategories.size());
            Segmentation valueSegmentation = new Segmentation(Segmentation.MultipleModelMethod.SUM, valueSegments);
            MiningModel valueMiningModel = new MiningModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Schema)segmentSchema)).setSegmentation(valueSegmentation).setTargets(SoftMaxClassification.createTargets(base_score, segmentSchema)).setOutput(SoftMaxClassification.createOutput(TRANSFORMATION, targetCategory));
            models.add(valueMiningModel);
        }
        return MiningModelUtil.createClassification((Schema)schema, models, (RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.SIMPLEMAX, (boolean)true);
    }

    private static <E> List<E> getColumn(List<E> values, int index, int rows, int columns) {
        if (values.size() != rows * columns) {
            throw new IllegalArgumentException();
        }
        ArrayList<E> result = new ArrayList<E>();
        for (int row = 0; row < rows; ++row) {
            result.add(values.get(row * columns + index));
        }
        return result;
    }
}

