/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.xgboost.Node;
import org.jpmml.xgboost.NodeStat;
import org.jpmml.xgboost.XGBoostDataInput;

public class RegTree {
    private int num_roots;
    private int num_nodes;
    private int num_deleted;
    private int max_depth;
    private int num_feature;
    private int size_leaf_vector;
    private List<Node> nodes;
    private List<NodeStat> stats;

    public void load(XGBoostDataInput input) throws IOException {
        int i;
        this.num_roots = input.readInt();
        this.num_nodes = input.readInt();
        this.num_deleted = input.readInt();
        this.max_depth = input.readInt();
        this.num_feature = input.readInt();
        this.size_leaf_vector = input.readInt();
        input.readReserved(31);
        this.nodes = new ArrayList<Node>();
        for (i = 0; i < this.num_nodes; ++i) {
            Node node = new Node();
            node.load(input);
            this.nodes.add(node);
        }
        this.stats = new ArrayList<NodeStat>();
        for (i = 0; i < this.num_nodes; ++i) {
            NodeStat stat = new NodeStat();
            stat.load(input);
            this.stats.add(stat);
        }
    }

    public TreeModel encodeTreeModel(Schema schema) {
        org.dmg.pmml.tree.Node root = new org.dmg.pmml.tree.Node().setPredicate((Predicate)new True());
        this.encodeNode(root, 0, schema);
        TreeModel treeModel = new TreeModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Schema)schema), root).setSplitCharacteristic(TreeModel.SplitCharacteristic.BINARY_SPLIT).setMissingValueStrategy(TreeModel.MissingValueStrategy.DEFAULT_CHILD);
        return treeModel;
    }

    private void encodeNode(org.dmg.pmml.tree.Node parent, int index, Schema schema) {
        parent.setId(String.valueOf(index + 1));
        Node node = this.nodes.get(index);
        if (!node.is_leaf()) {
            int splitIndex = node.split_index();
            Feature feature = schema.getFeature(splitIndex);
            org.dmg.pmml.tree.Node leftChild = new org.dmg.pmml.tree.Node().setPredicate(RegTree.encodePredicate(feature, node, true));
            this.encodeNode(leftChild, node.cleft(), schema);
            org.dmg.pmml.tree.Node rightChild = new org.dmg.pmml.tree.Node().setPredicate(RegTree.encodePredicate(feature, node, false));
            this.encodeNode(rightChild, node.cright(), schema);
            parent.addNodes(new org.dmg.pmml.tree.Node[]{leftChild, rightChild});
            boolean defaultLeft = RegTree.isDefaultLeft(feature, node);
            parent.setDefaultChild(defaultLeft ? leftChild.getId() : rightChild.getId());
        } else {
            float value = node.leaf_value();
            parent.setScore(ValueUtil.formatValue((Number)Float.valueOf(value)));
        }
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    private static Predicate encodePredicate(Feature feature, Node node, boolean left) {
        String value;
        SimplePredicate.Operator operator;
        FieldName name = feature.getName();
        if (feature instanceof BinaryFeature) {
            BinaryFeature binaryFeature = (BinaryFeature)feature;
            operator = left ? SimplePredicate.Operator.NOT_EQUAL : SimplePredicate.Operator.EQUAL;
            value = binaryFeature.getValue();
        } else {
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            Number splitValue = Float.valueOf(Float.intBitsToFloat(node.split_cond()));
            DataType dataType = continuousFeature.getDataType();
            switch (dataType) {
                case INTEGER: {
                    splitValue = (int)(((Number)splitValue).floatValue() + 1.0f);
                    break;
                }
                case FLOAT: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            operator = left ? SimplePredicate.Operator.LESS_THAN : SimplePredicate.Operator.GREATER_OR_EQUAL;
            value = ValueUtil.formatValue((Number)splitValue);
        }
        SimplePredicate simplePredicate = new SimplePredicate(name, operator).setValue(value);
        return simplePredicate;
    }

    private static boolean isDefaultLeft(Feature feature, Node node) {
        if (feature instanceof BinaryFeature) {
            return true;
        }
        return node.default_left();
    }
}

