/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.regression.RegressionModel;
import org.jpmml.converter.CMatrixUtil;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.Transformation;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.xgboost.Classification;
import org.jpmml.xgboost.RegTree;

public class MultinomialLogisticRegression
extends Classification {
    public MultinomialLogisticRegression(int num_class) {
        super(num_class);
        if (num_class < 3) {
            throw new IllegalArgumentException("Multi-class classification requires three or more target categories");
        }
    }

    @Override
    public MiningModel encodeMiningModel(List<RegTree> regTrees, float base_score, Integer ntreeLimit, Schema schema) {
        Schema segmentSchema = new Schema((Label)new ContinuousLabel(null, DataType.FLOAT), schema.getFeatures());
        ArrayList<MiningModel> miningModels = new ArrayList<MiningModel>();
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        int columns = categoricalLabel.size();
        int rows = regTrees.size() / columns;
        for (int i = 0; i < columns; ++i) {
            MiningModel miningModel = MultinomialLogisticRegression.createMiningModel(CMatrixUtil.getColumn(regTrees, (int)rows, (int)columns, (int)i), base_score, ntreeLimit, segmentSchema).setOutput(ModelUtil.createPredictedOutput((FieldName)FieldName.create((String)("xgbValue(" + categoricalLabel.getValue(i) + ")")), (OpType)OpType.CONTINUOUS, (DataType)DataType.FLOAT, (Transformation[])new Transformation[0]));
            miningModels.add(miningModel);
        }
        return MiningModelUtil.createClassification(miningModels, (RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.SOFTMAX, (boolean)true, (Schema)schema);
    }
}

