/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost.visitors;

import java.util.Deque;
import java.util.List;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.True;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.model.visitors.AbstractVisitor;

public class TreeModelCompactor
extends AbstractVisitor {
    public void pushParent(PMMLObject object) {
        super.pushParent(object);
        if (object instanceof Node) {
            this.handleNodePush((Node)object);
        }
    }

    public PMMLObject popParent() {
        PMMLObject object = super.popParent();
        if (object instanceof Node) {
            this.handleNodePop((Node)object);
        }
        return object;
    }

    public VisitorAction visit(TreeModel treeModel) {
        TreeModel.MissingValueStrategy missingValueStrategy = treeModel.getMissingValueStrategy();
        TreeModel.NoTrueChildStrategy noTrueChildStrategy = treeModel.getNoTrueChildStrategy();
        TreeModel.SplitCharacteristic splitCharacteristic = treeModel.getSplitCharacteristic();
        if (!(TreeModel.MissingValueStrategy.DEFAULT_CHILD.equals((Object)missingValueStrategy) && TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION.equals((Object)noTrueChildStrategy) && TreeModel.SplitCharacteristic.BINARY_SPLIT.equals((Object)splitCharacteristic))) {
            throw new IllegalArgumentException();
        }
        treeModel.setMissingValueStrategy(TreeModel.MissingValueStrategy.NONE).setNoTrueChildStrategy(TreeModel.NoTrueChildStrategy.RETURN_LAST_PREDICTION).setSplitCharacteristic(TreeModel.SplitCharacteristic.MULTI_SPLIT);
        return super.visit(treeModel);
    }

    private void handleNodePush(Node node) {
        String defaultChild = node.getDefaultChild();
        String id = node.getId();
        String score = node.getScore();
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (node.hasNodes()) {
            List children = node.getNodes();
            if (children.size() != 2 || defaultChild == null || score != null) {
                throw new IllegalArgumentException();
            }
            Node firstChild = (Node)children.get(0);
            Node secondChild = (Node)children.get(1);
            if (defaultChild.equals(firstChild.getId())) {
                children.remove(0);
                children.add(1, firstChild);
                firstChild = (Node)children.get(0);
                secondChild = (Node)children.get(1);
            } else if (!defaultChild.equals(secondChild.getId())) {
                throw new IllegalArgumentException();
            }
            node.setDefaultChild(null);
            secondChild.setPredicate((Predicate)new True());
        } else if (defaultChild != null || score == null) {
            throw new IllegalArgumentException();
        }
        node.setId(null);
    }

    private void handleNodePop(Node node) {
        String score = node.getScore();
        Predicate predicate = node.getPredicate();
        if (predicate instanceof True) {
            Node parentNode = this.getParentNode();
            if (parentNode == null) {
                return;
            }
            String parentScore = parentNode.getScore();
            if (parentScore != null) {
                throw new IllegalArgumentException();
            }
            parentNode.setScore(score);
            List parentChildren = parentNode.getNodes();
            boolean success = parentChildren.remove(node);
            if (!success) {
                throw new IllegalArgumentException();
            }
            if (node.hasNodes()) {
                List children = node.getNodes();
                parentChildren.addAll(children);
            }
        }
    }

    private Node getParentNode() {
        Deque parents = this.getParents();
        PMMLObject parent = (PMMLObject)parents.peekFirst();
        if (parent instanceof Node) {
            return (Node)parent;
        }
        return null;
    }
}

