/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PredicateManager;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.xgboost.RegTree;

public abstract class ObjFunction {
    public abstract Label encodeLabel(FieldName var1, List<String> var2, PMMLEncoder var3);

    public abstract MiningModel encodeMiningModel(List<RegTree> var1, float var2, Integer var3, Schema var4);

    protected static MiningModel createMiningModel(List<RegTree> regTrees, float base_score, Integer ntreeLimit, Schema schema) {
        ContinuousLabel continuousLabel = (ContinuousLabel)schema.getLabel();
        Schema segmentSchema = schema.toAnonymousSchema();
        PredicateManager predicateManager = new PredicateManager();
        ArrayList<TreeModel> treeModels = new ArrayList<TreeModel>();
        if (ntreeLimit != null) {
            if (ntreeLimit > regTrees.size()) {
                throw new IllegalArgumentException("Tree limit " + ntreeLimit + " is greater than the number of trees");
            }
            regTrees = regTrees.subList(0, ntreeLimit);
        }
        for (RegTree regTree : regTrees) {
            TreeModel treeModel = regTree.encodeTreeModel(predicateManager, segmentSchema);
            treeModels.add(treeModel);
        }
        MiningModel miningModel = new MiningModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Label)continuousLabel)).setMathContext(MathContext.FLOAT).setSegmentation(MiningModelUtil.createSegmentation((Segmentation.MultipleModelMethod)Segmentation.MultipleModelMethod.SUM, treeModels)).setTargets(ModelUtil.createRescaleTargets(null, (Number)ValueUtil.floatToDouble((Float)Float.valueOf(base_score)), (ContinuousLabel)continuousLabel));
        return miningModel;
    }
}

