/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.LinkedHashMap;
import java.util.List;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMML;
import org.jpmml.model.metro.MetroJAXBUtil;
import org.jpmml.xgboost.ByteOrderUtil;
import org.jpmml.xgboost.FeatureMap;
import org.jpmml.xgboost.Learner;
import org.jpmml.xgboost.XGBoostUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    @Parameter(names={"--fmap-input"}, description="XGBoost feature map input file", required=true)
    private File fmapInput = null;
    @Parameter(names={"--help"}, description="Show the list of configuration options and exit", help=true)
    private boolean help = false;
    @Parameter(names={"--model-input"}, description="XGBoost model input file", required=true)
    private File modelInput = null;
    @Parameter(names={"--byte-order"}, description="Endianness of XGBoost model input file. Possible values \"BIG_ENDIAN\" (\"BE\") or \"LITTLE_ENDIAN\" (\"LE\")")
    private String byteOrder = ByteOrder.nativeOrder().toString();
    @Parameter(names={"--charset"}, description="Charset of XGBoost model input file")
    private String charset = null;
    @Parameter(names={"--json-path"}, description="JSONPath expression of the JSON model element")
    private String jsonPath = "$";
    @Parameter(names={"--missing-value"}, description="String representation of feature value(s) that should be regarded as missing")
    private String missingValue = null;
    @Parameter(names={"--pmml-output"}, description="PMML output file", required=true)
    private File pmmlOutput = null;
    @Parameter(names={"--target-name"}, description="Target name. Defaults to \"_target\"")
    private String targetName = null;
    @Parameter(names={"--target-categories"}, description="Target categories. Defaults to 0-based index [0, 1, .., num_class - 1]")
    private List<String> targetCategories = null;
    @Parameter(names={"--X-compact"}, description="Transform XGBoost-style trees to PMML-style trees", arity=1)
    private boolean compact = true;
    @Parameter(names={"--X-nan-as-missing"}, description="Treat Not-a-Number (NaN) values as missing values", arity=1)
    private boolean nanAsMissing = true;
    @Parameter(names={"--X-ntree-limit"}, description="Limit the number of trees. Defaults to all trees")
    private Integer ntreeLimit = null;
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        JCommander commander = new JCommander((Object)main);
        commander.setProgramName(Main.class.getName());
        try {
            commander.parse(args);
        }
        catch (ParameterException pe) {
            StringBuilder sb = new StringBuilder();
            sb.append(pe.toString());
            sb.append("\n");
            commander.usage(sb);
            System.err.println(sb.toString());
            System.exit(-1);
        }
        if (main.help) {
            StringBuilder sb = new StringBuilder();
            commander.usage(sb);
            System.out.println(sb.toString());
            System.exit(0);
        }
        main.run();
    }

    private void run() throws Exception {
        PMML pmml;
        long end;
        FeatureMap featureMap;
        long begin;
        Learner learner;
        ByteOrder byteOrder = ByteOrderUtil.forValue(this.byteOrder);
        try (FileInputStream is = new FileInputStream(this.modelInput);){
            logger.info("Parsing learner..");
            long begin2 = System.currentTimeMillis();
            learner = XGBoostUtil.loadLearner(is, byteOrder, this.charset, this.jsonPath);
            long end2 = System.currentTimeMillis();
            logger.info("Parsed learner in {} ms.", (Object)(end2 - begin2));
        }
        catch (Exception e) {
            logger.error("Failed to parse learner", (Throwable)e);
            throw e;
        }
        try (FileInputStream is = new FileInputStream(this.fmapInput);){
            logger.info("Parsing feature map..");
            begin = System.currentTimeMillis();
            featureMap = XGBoostUtil.loadFeatureMap(is);
            end = System.currentTimeMillis();
            logger.info("Parsed feature map in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to parse feature map", (Throwable)e);
            throw e;
        }
        if (this.missingValue != null) {
            featureMap.addMissingValue(this.missingValue);
        }
        LinkedHashMap<String, Comparable<Boolean>> options = new LinkedHashMap<String, Comparable<Boolean>>();
        options.put("compact", Boolean.valueOf(this.compact));
        options.put("nan_as_missing", Boolean.valueOf(this.nanAsMissing));
        options.put("ntree_limit", this.ntreeLimit);
        try {
            logger.info("Converting learner to PMML..");
            begin = System.currentTimeMillis();
            pmml = learner.encodePMML(options, this.targetName != null ? FieldName.create((String)this.targetName) : null, this.targetCategories, featureMap);
            end = System.currentTimeMillis();
            logger.info("Converted learner to PMML in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to convert learner to PMML", (Throwable)e);
            throw e;
        }
        try (FileOutputStream os = new FileOutputStream(this.pmmlOutput);){
            logger.info("Marshalling PMML..");
            long begin3 = System.currentTimeMillis();
            MetroJAXBUtil.marshalPMML((PMML)pmml, (OutputStream)os);
            long end3 = System.currentTimeMillis();
            logger.info("Marshalled PMML in {} ms.", (Object)(end3 - begin3));
        }
        catch (Exception e) {
            logger.error("Failed to marshal PMML", (Throwable)e);
            throw e;
        }
    }
}

