/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.maven.plugins;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.vafer.jdependency.Clazz;
import org.vafer.jdependency.Clazzpath;

@Mojo(name="minify", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class MinifyMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter(required=true)
    String artifact;
    @Parameter(required=true)
    Set<String> entryPoints;
    @Parameter(required=true)
    File outputFile;

    public void execute() throws MojoExecutionException {
        Map artifactMap = this.project.getArtifactMap();
        Artifact targetArtifact = (Artifact)artifactMap.get(this.artifact);
        if (targetArtifact == null) {
            throw new MojoExecutionException("Failed to minify artifact: parameter artifact refers to artifact " + this.artifact + " that is not contained in project artifacts");
        }
        File targetArtifactFile = targetArtifact.getFile();
        LinkedHashSet<String> entryPoints = new LinkedHashSet<String>(this.entryPoints);
        LinkedHashSet<String> expandableEntryPoints = new LinkedHashSet<String>();
        Iterator it = entryPoints.iterator();
        while (it.hasNext()) {
            String entryPoint2 = (String)it.next();
            if (!entryPoint2.startsWith("META-INF") || !entryPoint2.endsWith(".properties")) continue;
            it.remove();
            expandableEntryPoints.add(entryPoint2);
        }
        try {
            final Clazzpath clazzpath = new Clazzpath();
            Artifact projectArtifact = this.project.getArtifact();
            File projectArtifactFile = projectArtifact.getFile();
            clazzpath.addClazzpathUnit(projectArtifactFile);
            if (!expandableEntryPoints.isEmpty()) {
                entryPoints.addAll(MinifyMojo.expandEntryPoints(projectArtifactFile, expandableEntryPoints));
            }
            Collection dependencyArtifacts = artifactMap.values();
            for (Artifact dependencyArtifact : dependencyArtifacts) {
                File dependencyArtifactFile = dependencyArtifact.getFile();
                clazzpath.addClazzpathUnit(dependencyArtifactFile);
                if (expandableEntryPoints.isEmpty()) continue;
                entryPoints.addAll(MinifyMojo.expandEntryPoints(dependencyArtifactFile, expandableEntryPoints));
            }
            Set entryPointClazzes = entryPoints.stream().map(entryPoint -> clazzpath.getClazz(entryPoint)).collect(Collectors.toSet());
            final Set removableClazzes = clazzpath.getClazzes();
            entryPointClazzes.stream().forEach(entryPointClazz -> {
                removableClazzes.remove(entryPointClazz);
                Set transitiveDependencyClazzes = entryPointClazz.getTransitiveDependencies();
                if (!transitiveDependencyClazzes.isEmpty()) {
                    removableClazzes.removeAll(transitiveDependencyClazzes);
                }
            });
            Predicate<JarEntry> predicate = new Predicate<JarEntry>(){

                @Override
                public boolean test(JarEntry jarEntry) {
                    String name = jarEntry.getName();
                    if (name.endsWith(".class")) {
                        Clazz clazz = clazzpath.getClazz(name.substring(0, name.length() - ".class".length()).replace('/', '.'));
                        return !removableClazzes.contains(clazz);
                    }
                    return true;
                }
            };
            MinifyMojo.filterJarFile(targetArtifactFile, this.outputFile, predicate);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to minify artifact", e);
        }
    }

    private static void filterJarFile(File inputFile, File outputFile, Predicate<JarEntry> predicate) throws IOException {
        try (JarFile jarFile = new JarFile(inputFile);
             JarOutputStream jarOs = new JarOutputStream(new FileOutputStream(outputFile));){
            byte[] buffer = new byte[16384];
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (!predicate.test(jarEntry)) continue;
                jarOs.putNextEntry(jarEntry);
                try (InputStream jarIs = jarFile.getInputStream(jarEntry);){
                    int length;
                    while ((length = jarIs.read(buffer)) >= 0) {
                        jarOs.write(buffer, 0, length);
                    }
                }
                jarOs.closeEntry();
            }
        }
    }

    private static Set<String> expandEntryPoints(File file, Set<String> entryPoints) throws IOException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        try (JarFile jarFile = new JarFile(file);){
            for (String entryPoint : entryPoints) {
                JarEntry jarEntry = (JarEntry)jarFile.getEntry(entryPoint);
                if (jarEntry == null) continue;
                if (entryPoint.startsWith("META-INF") && entryPoint.endsWith(".properties")) {
                    result.addAll(MinifyMojo.loadPropertyValues(jarFile, jarEntry));
                    continue;
                }
                throw new IllegalArgumentException(entryPoint);
            }
        }
        return result;
    }

    private static Set<String> loadPropertyValues(JarFile jarFile, JarEntry jarEntry) throws IOException {
        Properties properties = new Properties();
        try (InputStream is = jarFile.getInputStream(jarEntry);){
            properties.load(is);
        }
        return properties.values().stream().map(String.class::cast).collect(Collectors.toSet());
    }
}

