/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.maven.plugins;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.vafer.jdependency.Clazz;
import org.vafer.jdependency.Clazzpath;

@Mojo(name="minify", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class MinifyMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter(required=true)
    Set<String> artifacts;
    @Parameter
    Set<String> entryPoints = Collections.emptySet();
    @Parameter
    Set<String> propertyEntryPoints = Collections.emptySet();
    @Parameter
    Set<String> serviceEntryPoints = Collections.emptySet();
    @Parameter(required=true)
    File outputDir;

    public void execute() throws MojoExecutionException {
        Map artifactMap = this.project.getArtifactMap();
        LinkedHashSet<Artifact> targetArtifacts = new LinkedHashSet<Artifact>();
        for (String artifact : this.artifacts) {
            Artifact targetArtifact = (Artifact)artifactMap.get(artifact);
            if (targetArtifact == null) {
                throw new MojoExecutionException("Failed to minify artifact: parameter artifacts refers to artifact " + artifact + " that is not contained in project artifacts");
            }
            targetArtifacts.add(targetArtifact);
        }
        LinkedHashSet<String> entryPoints = new LinkedHashSet<String>(this.entryPoints);
        try {
            final Clazzpath clazzpath = new Clazzpath();
            Artifact projectArtifact = this.project.getArtifact();
            File projectArtifactFile = projectArtifact.getFile();
            clazzpath.addClazzpathUnit(projectArtifactFile);
            entryPoints.addAll(this.expandEntryPoints(projectArtifactFile));
            Collection dependencyArtifacts = artifactMap.values();
            for (Artifact dependencyArtifact : dependencyArtifacts) {
                File dependencyArtifactFile = dependencyArtifact.getFile();
                clazzpath.addClazzpathUnit(dependencyArtifactFile);
                entryPoints.addAll(this.expandEntryPoints(dependencyArtifactFile));
            }
            Set entryPointClazzes = entryPoints.stream().map(entryPoint -> clazzpath.getClazz(entryPoint)).collect(Collectors.toSet());
            final Set removableClazzes = clazzpath.getClazzes();
            entryPointClazzes.stream().forEach(entryPointClazz -> {
                removableClazzes.remove(entryPointClazz);
                Set transitiveDependencyClazzes = entryPointClazz.getTransitiveDependencies();
                if (!transitiveDependencyClazzes.isEmpty()) {
                    removableClazzes.removeAll(transitiveDependencyClazzes);
                }
            });
            Predicate<JarEntry> predicate = new Predicate<JarEntry>(){

                @Override
                public boolean test(JarEntry jarEntry) {
                    String name = jarEntry.getName();
                    if (name.endsWith(".class")) {
                        Clazz clazz = clazzpath.getClazz(name.substring(0, name.length() - ".class".length()).replace('/', '.'));
                        return !removableClazzes.contains(clazz);
                    }
                    return true;
                }
            };
            for (Artifact targetArtifact : targetArtifacts) {
                File targetArtifactFile = targetArtifact.getFile();
                MinifyMojo.filterJarFile(targetArtifactFile, new File(this.outputDir, targetArtifact.getArtifactId() + "-" + targetArtifact.getVersion() + "-minified.jar"), predicate);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to minify artifact", e);
        }
    }

    private Set<String> expandEntryPoints(File file) throws IOException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        try (JarFile jarFile = new JarFile(file);){
            JarEntry jarEntry;
            for (String propertyEntryPoint : this.propertyEntryPoints) {
                jarEntry = (JarEntry)jarFile.getEntry(propertyEntryPoint);
                if (jarEntry == null) continue;
                result.addAll(MinifyMojo.loadPropertyValues(jarFile, jarEntry));
            }
            for (String serviceEntryPoint : this.serviceEntryPoints) {
                jarEntry = (JarEntry)jarFile.getEntry(serviceEntryPoint);
                if (jarEntry == null) continue;
                result.addAll(MinifyMojo.loadServices(jarFile, jarEntry));
            }
        }
        return result;
    }

    private static void filterJarFile(File inputFile, File outputFile, Predicate<JarEntry> predicate) throws IOException {
        try (JarFile jarFile = new JarFile(inputFile);
             JarOutputStream jarOs = new JarOutputStream(new FileOutputStream(outputFile));){
            byte[] buffer = new byte[16384];
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (!predicate.test(jarEntry)) continue;
                jarOs.putNextEntry(jarEntry);
                try (InputStream jarIs = jarFile.getInputStream(jarEntry);){
                    int length;
                    while ((length = jarIs.read(buffer)) >= 0) {
                        jarOs.write(buffer, 0, length);
                    }
                }
                jarOs.closeEntry();
            }
        }
    }

    private static Set<String> loadPropertyValues(JarFile jarFile, JarEntry jarEntry) throws IOException {
        Properties properties = new Properties();
        try (InputStream is = jarFile.getInputStream(jarEntry);){
            properties.load(is);
        }
        return properties.values().stream().map(String.class::cast).collect(Collectors.toSet());
    }

    private static Set<String> loadServices(JarFile jarFile, JarEntry jarEntry) throws IOException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        try (InputStream is = jarFile.getInputStream(jarEntry);){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                int hash = (line = line.trim()).indexOf(35);
                if (hash > -1) {
                    line = line.substring(0, hash);
                }
                if (line.isEmpty()) continue;
                result.add(line);
            }
            reader.close();
        }
        return result;
    }
}

