/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.maven.plugins;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jpmml.maven.plugins.Minify;
import org.vafer.jdependency.Clazz;
import org.vafer.jdependency.Clazzpath;

@Mojo(name="create-classpath", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class CreateClasspathMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter
    Minify minify;
    @Parameter(required=true)
    File outputDirectory;

    public void execute() throws MojoExecutionException {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        Artifact projectArtifact = this.project.getArtifact();
        if (Objects.equals(projectArtifact.getType(), "jar")) {
            artifacts.add(projectArtifact);
        }
        ArrayList dependencyArtifacts = new ArrayList(this.project.getArtifacts());
        Comparator<Artifact> comparator = new Comparator<Artifact>(){

            @Override
            public int compare(Artifact left, Artifact right) {
                return left.getArtifactId().compareTo(right.getArtifactId());
            }
        };
        Collections.sort(dependencyArtifacts, comparator);
        for (Artifact dependencyArtifact : dependencyArtifacts) {
            if (!Objects.equals(dependencyArtifact.getType(), "jar")) continue;
            artifacts.add(dependencyArtifact);
        }
        try {
            if (!this.outputDirectory.exists()) {
                this.outputDirectory.mkdirs();
            }
            ArrayList<String> elements = new ArrayList<String>();
            if (this.minify != null) {
                final Clazzpath clazzpath = new Clazzpath();
                LinkedHashSet<String> entryPoints = new LinkedHashSet<String>();
                entryPoints.addAll(this.minify.getEntryPoints());
                for (Artifact artifact : artifacts) {
                    File artifactFile = artifact.getFile();
                    clazzpath.addClazzpathUnit(artifactFile);
                    entryPoints.addAll(this.minify.getEntryPoints(artifactFile));
                }
                Set entryPointClazzes = entryPoints.stream().map(entryPoint -> clazzpath.getClazz(entryPoint)).collect(Collectors.toSet());
                final Set removableClazzes = clazzpath.getClazzes();
                entryPointClazzes.stream().forEach(entryPointClazz -> {
                    removableClazzes.remove(entryPointClazz);
                    Set transitiveDependencyClazzes = entryPointClazz.getTransitiveDependencies();
                    if (!transitiveDependencyClazzes.isEmpty()) {
                        removableClazzes.removeAll(transitiveDependencyClazzes);
                    }
                });
                Predicate<JarEntry> predicate = new Predicate<JarEntry>(){

                    @Override
                    public boolean test(JarEntry jarEntry) {
                        String name = jarEntry.getName();
                        if (name.endsWith(".class")) {
                            Clazz clazz = clazzpath.getClazz(name.substring(0, name.length() - ".class".length()).replace('/', '.'));
                            return !removableClazzes.contains(clazz);
                        }
                        return true;
                    }
                };
                for (Artifact artifact : artifacts) {
                    if (this.minify.accept(artifact)) {
                        elements.add(this.copyArtifactFile(artifact, predicate));
                        continue;
                    }
                    elements.add(this.copyArtifactFile(artifact));
                }
            } else {
                for (Artifact artifact : artifacts) {
                    elements.add(this.copyArtifactFile(artifact));
                }
            }
            File outputFile = new File(this.outputDirectory, "classpath.txt");
            FileOutputStream os = new FileOutputStream(outputFile);
            Object object = null;
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
                Iterator it = elements.iterator();
                while (it.hasNext()) {
                    writer.write((String)it.next());
                    if (!it.hasNext()) continue;
                    ((Writer)writer).write(10);
                }
                ((Writer)writer).close();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (os != null) {
                    if (object != null) {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((OutputStream)os).close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create classpath", e);
        }
    }

    private String copyArtifactFile(Artifact artifact, Predicate<JarEntry> predicate) throws IOException {
        String artifactFileName = artifact.getArtifactId() + "-" + artifact.getVersion() + "-minified.jar";
        File inputFile = artifact.getFile();
        File outputFile = new File(this.outputDirectory, artifactFileName);
        try (JarFile jarFile = new JarFile(inputFile);
             JarOutputStream jarOs = new JarOutputStream(new FileOutputStream(outputFile));){
            byte[] buffer = new byte[16384];
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (!predicate.test(jarEntry)) continue;
                jarOs.putNextEntry(jarEntry);
                try (InputStream jarIs = jarFile.getInputStream(jarEntry);){
                    int length;
                    while ((length = jarIs.read(buffer)) >= 0) {
                        jarOs.write(buffer, 0, length);
                    }
                }
                jarOs.closeEntry();
            }
        }
        return artifactFileName;
    }

    private String copyArtifactFile(Artifact artifact) throws IOException {
        String artifactFileName = artifact.getArtifactId() + "-" + artifact.getVersion() + ".jar";
        File inputFile = artifact.getFile();
        File outputFile = new File(this.outputDirectory, artifactFileName);
        Files.copy(inputFile.toPath(), outputFile.toPath(), new CopyOption[0]);
        return artifactFileName;
    }
}

