/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.maven.plugins;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.Parameter;

public class Minify {
    @Parameter(required=true)
    Set<String> artifacts;
    @Parameter
    Set<String> entryPoints = Collections.emptySet();
    @Parameter
    Set<String> propertyEntryPoints = Collections.emptySet();
    @Parameter
    Set<String> serviceEntryPoints = Collections.emptySet();

    public boolean accept(Artifact artifact) {
        return this.artifacts.contains(artifact.getGroupId() + ":" + artifact.getArtifactId());
    }

    Set<String> getEntryPoints() {
        return this.entryPoints;
    }

    Set<String> getEntryPoints(File file) throws IOException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        try (JarFile jarFile = new JarFile(file);){
            JarEntry jarEntry;
            for (String propertyEntryPoint : this.propertyEntryPoints) {
                jarEntry = (JarEntry)jarFile.getEntry(propertyEntryPoint);
                if (jarEntry == null) continue;
                result.addAll(Minify.loadPropertyValues(jarFile, jarEntry));
            }
            for (String serviceEntryPoint : this.serviceEntryPoints) {
                jarEntry = (JarEntry)jarFile.getEntry(serviceEntryPoint);
                if (jarEntry == null) continue;
                result.addAll(Minify.loadServices(jarFile, jarEntry));
            }
        }
        return result;
    }

    private static Set<String> loadPropertyValues(JarFile jarFile, JarEntry jarEntry) throws IOException {
        Properties properties = new Properties();
        try (InputStream is = jarFile.getInputStream(jarEntry);){
            properties.load(is);
        }
        return properties.values().stream().map(String.class::cast).collect(Collectors.toSet());
    }

    private static Set<String> loadServices(JarFile jarFile, JarEntry jarEntry) throws IOException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        try (InputStream is = jarFile.getInputStream(jarEntry);){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                int hash = (line = line.trim()).indexOf(35);
                if (hash > -1) {
                    line = line.substring(0, hash);
                }
                if (line.isEmpty()) continue;
                result.add(line);
            }
            reader.close();
        }
        return result;
    }
}

