/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.cascading;

import cascading.tuple.Fields;
import java.lang.reflect.Type;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OutputField;
import org.jpmml.evaluator.Evaluator;

public class FieldsUtil {
    private FieldsUtil() {
    }

    public static Fields getActiveFields(Evaluator evaluator) {
        return FieldsUtil.getDataFields(evaluator, evaluator.getActiveFields());
    }

    public static Fields getGroupFields(Evaluator evaluator) {
        return FieldsUtil.getDataFields(evaluator, evaluator.getGroupFields());
    }

    public static Fields getPredictedFields(Evaluator evaluator) {
        return FieldsUtil.getDataFields(evaluator, evaluator.getPredictedFields());
    }

    private static Fields getDataFields(Evaluator evaluator, List<FieldName> dataFields) {
        Fields result = new Fields(new Comparable[0]);
        for (FieldName dataField : dataFields) {
            DataField field = evaluator.getDataField(dataField);
            result = result.append(FieldsUtil.createFields(dataField.getValue(), (Field)field));
        }
        return result;
    }

    public static Fields getOutputFields(Evaluator evaluator) {
        Fields result = new Fields(new Comparable[0]);
        List outputFields = evaluator.getOutputFields();
        for (FieldName outputField : outputFields) {
            OutputField field = evaluator.getOutputField(outputField);
            result = result.append(FieldsUtil.createFields(outputField.getValue(), (Field)field));
        }
        return result;
    }

    private static Fields createFields(String name, Field field) {
        DataType dataType = field.getDataType();
        if (dataType == null) {
            dataType = DataType.STRING;
        }
        return new Fields((Comparable)((Object)name), FieldsUtil.getType(dataType));
    }

    private static Type getType(DataType dataType) {
        switch (dataType) {
            case STRING: {
                return String.class;
            }
            case INTEGER: {
                return Integer.class;
            }
            case FLOAT: 
            case DOUBLE: {
                return Double.class;
            }
        }
        throw new IllegalArgumentException();
    }
}

