/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.cascading;

import cascading.flow.AssemblyPlanner;
import cascading.flow.Flow;
import cascading.flow.planner.PlannerException;
import cascading.operation.Aggregator;
import cascading.operation.Function;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.pipe.assembly.Retain;
import cascading.tuple.Fields;
import java.util.Collections;
import java.util.List;
import org.jpmml.cascading.CollectionAggregator;
import org.jpmml.cascading.FieldsUtil;
import org.jpmml.cascading.PMMLFunction;
import org.jpmml.evaluator.Evaluator;

public class PMMLPlanner
implements AssemblyPlanner {
    private Evaluator evaluator = null;
    private String branchName = "pmml";
    private String headName = null;
    private String tailName = null;
    private Fields retainedFields = null;

    public PMMLPlanner(Evaluator evaluator) {
        this.setEvaluator(evaluator);
    }

    public List<Pipe> resolveTails(AssemblyPlanner.Context context) {
        Pipe tail;
        List tails = context.getTails();
        String headName = this.getHeadName();
        if (tails.size() == 0) {
            if (headName == null) {
                headName = this.findHeadName(context);
            }
            tail = new Pipe(headName);
        } else if (tails.size() == 1) {
            if (headName != null) {
                throw new PlannerException("Cannot specify a head name when there is an incoming branch");
            }
            tail = (Pipe)tails.get(0);
        } else {
            throw new PlannerException("Too many incoming branches to choose from");
        }
        String tailName = this.getTailName();
        if (tailName == null) {
            tailName = this.findTailName(context);
        }
        tail = new Pipe(tailName, this.resolveAssembly(tail));
        return Collections.singletonList(tail);
    }

    private Pipe resolveAssembly(Pipe pipe) {
        Pipe tail = pipe == null ? new Pipe(this.getBranchName()) : new Pipe(this.getBranchName(), pipe);
        Evaluator evaluator = this.getEvaluator();
        Fields retainedFields = this.getRetainedFields();
        if (retainedFields != null) {
            tail = new Retain(tail, retainedFields);
        }
        Fields activeFields = FieldsUtil.getActiveFields(evaluator);
        Fields groupFields = FieldsUtil.getGroupFields(evaluator);
        Fields predictedFields = FieldsUtil.getPredictedFields(evaluator);
        Fields outputFields = FieldsUtil.getOutputFields(evaluator);
        if (groupFields.size() > 0) {
            if (groupFields.size() > 1) {
                throw new PlannerException("Too many group by fields");
            }
            tail = new GroupBy(tail, groupFields);
            tail = new Every(tail, activeFields, (Aggregator)new CollectionAggregator(activeFields));
        }
        Fields argumentFields = activeFields.append(groupFields);
        Fields resultFields = predictedFields.append(outputFields);
        PMMLFunction function = new PMMLFunction(resultFields, evaluator);
        tail = new Each(tail, argumentFields, (Function)function, resultFields);
        return tail;
    }

    private String findHeadName(AssemblyPlanner.Context context) {
        Flow flow = context.getFlow();
        List sourceNames = flow.getSourceNames();
        if (sourceNames.size() != 1) {
            throw new PlannerException("Too many sources to choose from: " + sourceNames);
        }
        return (String)sourceNames.get(0);
    }

    private String findTailName(AssemblyPlanner.Context context) {
        Flow flow = context.getFlow();
        List sinkNames = flow.getSinkNames();
        if (sinkNames.size() != 1) {
            throw new PlannerException("Too many sinks to choose from: " + sinkNames);
        }
        return (String)sinkNames.get(0);
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    private void setEvaluator(Evaluator evaluator) {
        if (evaluator == null) {
            throw new NullPointerException();
        }
        this.evaluator = evaluator;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public PMMLPlanner setBranchName(String branchName) {
        if (branchName == null) {
            throw new NullPointerException();
        }
        this.branchName = branchName;
        return this;
    }

    public String getHeadName() {
        return this.headName;
    }

    public PMMLPlanner setHeadName(String headName) {
        this.headName = headName;
        return this;
    }

    public String getTailName() {
        return this.tailName;
    }

    public PMMLPlanner setTailName(String tailName) {
        this.tailName = tailName;
        return this;
    }

    public PMMLPlanner setRetainOnlyActiveFields() {
        Evaluator evaluator = this.getEvaluator();
        Fields incomingFields = FieldsUtil.getActiveFields(evaluator).append(FieldsUtil.getGroupFields(evaluator));
        return this.setRetainedFields(incomingFields);
    }

    public Fields getRetainedFields() {
        return this.retainedFields;
    }

    public PMMLPlanner setRetainedFields(Fields retainedFields) {
        this.retainedFields = retainedFields;
        return this;
    }
}

