/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.functions.AbstractFunction;

public class MeanFunction
extends AbstractFunction {
    public MeanFunction() {
        this(MeanFunction.class.getName());
    }

    public MeanFunction(String name) {
        super(name);
    }

    public FieldValue evaluate(List<FieldValue> arguments) {
        this.checkArguments(arguments, 1);
        Collection values = (Collection)FieldValueUtil.getValue(Collection.class, (FieldValue)arguments.get(0));
        Double result = MeanFunction.evaluate(values);
        return FieldValueUtil.create((DataType)DataType.DOUBLE, (OpType)OpType.CONTINUOUS, (Object)result);
    }

    private static Double evaluate(Collection<?> values) {
        Mean statistic = new Mean();
        for (Object value : values) {
            Double doubleValue = (Double)TypeUtil.parseOrCast((DataType)DataType.DOUBLE, value);
            statistic.increment(doubleValue.doubleValue());
        }
        return statistic.getResult();
    }
}

