/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.visitors;

import org.dmg.pmml.Array;
import org.dmg.pmml.False;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.Visitable;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.evaluator.ExtensionUtil;
import org.jpmml.evaluator.visitors.ElementHashMap;
import org.jpmml.evaluator.visitors.ElementKey;
import org.jpmml.model.visitors.PredicateFilterer;

public class PredicateInterner
extends PredicateFilterer {
    private ElementHashMap<SimplePredicate> simplePredicateCache = new ElementHashMap<SimplePredicate>(){

        @Override
        public ElementKey createKey(SimplePredicate simplePredicate) {
            Object[] content = new Object[]{simplePredicate.getField(), simplePredicate.getOperator(), simplePredicate.getValue()};
            return new ElementKey(content);
        }
    };
    private ElementHashMap<SimpleSetPredicate> simpleSetPredicateCache = new ElementHashMap<SimpleSetPredicate>(){

        @Override
        public ElementKey createKey(SimpleSetPredicate simpleSetPredicate) {
            Array array = simpleSetPredicate.getArray();
            Object[] content = new Object[]{simpleSetPredicate.getField(), simpleSetPredicate.getBooleanOperator(), ArrayUtil.getContent((Array)array)};
            return new ElementKey(content);
        }
    };
    private ElementHashMap<True> truePredicateCache = new ElementHashMap<True>(){

        @Override
        public ElementKey createKey(True truePredicate) {
            return ElementKey.EMPTY;
        }
    };
    private ElementHashMap<False> falsePredicateCache = new ElementHashMap<False>(){

        @Override
        public ElementKey createKey(False falsePredicate) {
            return ElementKey.EMPTY;
        }
    };

    public void applyTo(Visitable visitable) {
        this.reset();
        super.applyTo(visitable);
    }

    public void reset() {
        this.simplePredicateCache.clear();
        this.simpleSetPredicateCache.clear();
        this.truePredicateCache.clear();
        this.falsePredicateCache.clear();
    }

    public Predicate filter(Predicate predicate) {
        if (predicate == null || ExtensionUtil.hasExtensions((PMMLObject)predicate)) {
            return predicate;
        }
        return this.intern(predicate);
    }

    public Predicate intern(Predicate predicate) {
        if (predicate instanceof SimplePredicate) {
            return this.intern((SimplePredicate)predicate);
        }
        if (predicate instanceof SimpleSetPredicate) {
            return this.intern((SimpleSetPredicate)predicate);
        }
        if (predicate instanceof True) {
            return this.intern((True)predicate);
        }
        if (predicate instanceof False) {
            return this.intern((False)predicate);
        }
        return predicate;
    }

    private SimplePredicate intern(SimplePredicate simplePredicate) {
        return this.simplePredicateCache.intern(simplePredicate);
    }

    private SimpleSetPredicate intern(SimpleSetPredicate simpleSetPredicate) {
        return this.simpleSetPredicateCache.intern(simpleSetPredicate);
    }

    private True intern(True truePredicate) {
        return this.truePredicateCache.intern(truePredicate);
    }

    private False intern(False falsePredicate) {
        return this.falsePredicateCache.intern(falsePredicate);
    }
}

