/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.visitors;

import java.util.List;
import java.util.ListIterator;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.VisitorAction;
import org.jpmml.evaluator.InputFieldUtil;
import org.jpmml.evaluator.visitors.ElementHashMap;
import org.jpmml.evaluator.visitors.ElementKey;
import org.jpmml.model.visitors.AbstractVisitor;

public class MiningFieldInterner
extends AbstractVisitor {
    private ElementHashMap<MiningField> cache = new ElementHashMap<MiningField>(){

        @Override
        public ElementKey createKey(MiningField miningField) {
            Object[] content = new Object[]{miningField.getName()};
            return new ElementKey(content);
        }
    };

    public VisitorAction visit(MiningSchema miningSchema) {
        if (miningSchema.hasMiningFields()) {
            List miningFields = miningSchema.getMiningFields();
            ListIterator<MiningField> it = miningFields.listIterator();
            while (it.hasNext()) {
                it.set(this.intern((MiningField)it.next()));
            }
        }
        return super.visit(miningSchema);
    }

    private MiningField intern(MiningField miningField) {
        if (miningField == null || miningField.hasExtensions()) {
            return miningField;
        }
        if (!InputFieldUtil.isDefault(null, (MiningField)miningField)) {
            return miningField;
        }
        return this.cache.intern(miningField);
    }
}

