/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.visitors;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.dmg.pmml.Array;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.Model;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.PMMLElements;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.TargetValue;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.Value;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.baseline.FieldValue;
import org.dmg.pmml.baseline.FieldValueCount;
import org.dmg.pmml.general_regression.BaseCumHazardTables;
import org.dmg.pmml.general_regression.BaselineStratum;
import org.dmg.pmml.general_regression.Category;
import org.dmg.pmml.general_regression.GeneralRegressionModel;
import org.dmg.pmml.general_regression.PMMLAttributes;
import org.dmg.pmml.general_regression.PPCell;
import org.dmg.pmml.naive_bayes.BayesInput;
import org.dmg.pmml.naive_bayes.BayesInputs;
import org.dmg.pmml.naive_bayes.PairCounts;
import org.dmg.pmml.naive_bayes.TargetValueCount;
import org.dmg.pmml.regression.CategoricalPredictor;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.RichComplexArray;
import org.jpmml.evaluator.RichDataField;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.general_regression.RichBaseCumHazardTables;
import org.jpmml.evaluator.naive_bayes.RichBayesInput;
import org.jpmml.model.XPathUtil;
import org.jpmml.model.visitors.FieldResolver;

public class ValueOptimizer
extends FieldResolver {
    private Mode mode = null;
    private Map<FieldName, DataType> dataTypes = new HashMap<FieldName, DataType>();
    public static final ThreadLocal<Mode> MODE_PROVIDER = new ThreadLocal<Mode>(){

        @Override
        public Mode initialValue() {
            return Mode.LOOSE;
        }
    };

    public ValueOptimizer() {
        this(MODE_PROVIDER.get());
    }

    public ValueOptimizer(Mode mode) {
        this.setMode(mode);
    }

    public void applyTo(Visitable visitable) {
        this.dataTypes.clear();
        super.applyTo(visitable);
    }

    public PMMLObject popParent() {
        PMMLObject parent = super.popParent();
        if (parent instanceof Model) {
            this.dataTypes.clear();
        } else if (parent instanceof TransformationDictionary) {
            this.dataTypes.clear();
        } else if (parent instanceof LocalTransformations) {
            this.dataTypes.clear();
        }
        return parent;
    }

    public VisitorAction visit(BaselineStratum baselineStartum) {
        return super.visit(baselineStartum);
    }

    public VisitorAction visit(BayesInputs bayesInputs) {
        if (bayesInputs.hasBayesInputs()) {
            List content = bayesInputs.getBayesInputs();
            ListIterator<RichBayesInput> it = content.listIterator();
            while (it.hasNext()) {
                BayesInput bayesInput = (BayesInput)it.next();
                FieldName name = bayesInput.getField();
                if (name == null) {
                    throw new MissingAttributeException((PMMLObject)bayesInput, org.dmg.pmml.naive_bayes.PMMLAttributes.BAYESINPUT_FIELD);
                }
                DataType dataType = this.getDataType(name);
                if (dataType == null) continue;
                it.set(new RichBayesInput(dataType, bayesInput));
            }
        }
        return super.visit(bayesInputs);
    }

    public VisitorAction visit(CategoricalPredictor categoricalPredictor) {
        FieldName name = categoricalPredictor.getField();
        if (name == null) {
            throw new MissingAttributeException((PMMLObject)categoricalPredictor, org.dmg.pmml.regression.PMMLAttributes.CATEGORICALPREDICTOR_FIELD);
        }
        this.parseValue(name, categoricalPredictor);
        return super.visit(categoricalPredictor);
    }

    public VisitorAction visit(Category category) {
        return super.visit(category);
    }

    public VisitorAction visit(Constant constant) {
        Object value = constant.getValue();
        DataType dataType = constant.getDataType();
        if (dataType == null) {
            dataType = TypeUtil.getConstantDataType((Object)value);
        }
        if (value != null) {
            value = this.parseOrCast(dataType, value);
            constant.setValue(value);
        }
        return super.visit(constant);
    }

    public VisitorAction visit(DataDictionary dataDictionary) {
        if (dataDictionary.hasDataFields()) {
            List dataFields = dataDictionary.getDataFields();
            ListIterator<RichDataField> it = dataFields.listIterator();
            while (it.hasNext()) {
                it.set(new RichDataField((DataField)it.next()));
            }
        }
        return super.visit(dataDictionary);
    }

    public VisitorAction visit(Discretize discretize) {
        DataType dataType = discretize.getDataType();
        if (dataType != null) {
            Object defaultValue;
            Object mapMissingTo = discretize.getMapMissingTo();
            if (mapMissingTo != null) {
                mapMissingTo = this.parseOrCast(dataType, mapMissingTo);
                discretize.setMapMissingTo(mapMissingTo);
            }
            if ((defaultValue = discretize.getDefaultValue()) != null) {
                defaultValue = this.parseOrCast(dataType, defaultValue);
                discretize.setDefaultValue(defaultValue);
            }
        }
        return super.visit(discretize);
    }

    public VisitorAction visit(DiscretizeBin discretizeBin) {
        Object binValue;
        Discretize discretize = (Discretize)this.getParent();
        DataType dataType = discretize.getDataType();
        if (dataType != null && (binValue = discretizeBin.getBinValue()) != null) {
            binValue = this.parseOrCast(dataType, binValue);
            discretizeBin.setBinValue(binValue);
        }
        return super.visit(discretizeBin);
    }

    public VisitorAction visit(FieldValue fieldValue) {
        return super.visit(fieldValue);
    }

    public VisitorAction visit(FieldValueCount fieldValueCount) {
        return super.visit(fieldValueCount);
    }

    public VisitorAction visit(GeneralRegressionModel generalRegressionModel) {
        DataType dataType;
        FieldName baselineStrataVariable;
        BaseCumHazardTables baseCumHazardTables = generalRegressionModel.getBaseCumHazardTables();
        if (baseCumHazardTables != null && (baselineStrataVariable = generalRegressionModel.getBaselineStrataVariable()) != null && (dataType = this.getDataType(baselineStrataVariable)) != null) {
            generalRegressionModel.setBaseCumHazardTables((BaseCumHazardTables)new RichBaseCumHazardTables(dataType, baseCumHazardTables));
        }
        return super.visit(generalRegressionModel);
    }

    public VisitorAction visit(MiningField miningField) {
        FieldName name = miningField.getName();
        if (name == null) {
            throw new MissingAttributeException((PMMLObject)miningField, org.dmg.pmml.PMMLAttributes.MININGFIELD_NAME);
        }
        DataType dataType = this.getDataType(name);
        if (dataType != null) {
            Object invalidValueReplacement;
            Object missingValueReplacement = miningField.getMissingValueReplacement();
            if (missingValueReplacement != null) {
                missingValueReplacement = this.safeParseOrCast(dataType, missingValueReplacement);
                miningField.setMissingValueReplacement(missingValueReplacement);
            }
            if ((invalidValueReplacement = miningField.getInvalidValueReplacement()) != null) {
                invalidValueReplacement = this.safeParseOrCast(dataType, invalidValueReplacement);
                miningField.setInvalidValueReplacement(invalidValueReplacement);
            }
        }
        return super.visit(miningField);
    }

    public VisitorAction visit(NormDiscrete normDiscrete) {
        FieldName name = normDiscrete.getField();
        if (name == null) {
            throw new MissingAttributeException((PMMLObject)normDiscrete, org.dmg.pmml.PMMLAttributes.NORMDISCRETE_FIELD);
        }
        this.parseValue(name, normDiscrete);
        return super.visit(normDiscrete);
    }

    public VisitorAction visit(PairCounts pairCounts) {
        return super.visit(pairCounts);
    }

    public VisitorAction visit(PPCell ppCell) {
        FieldName name = ppCell.getField();
        if (name == null) {
            throw new MissingAttributeException((PMMLObject)ppCell, PMMLAttributes.PPCELL_FIELD);
        }
        this.parseValue(name, ppCell);
        return super.visit(ppCell);
    }

    public VisitorAction visit(SimplePredicate simplePredicate) {
        FieldName name = simplePredicate.getField();
        if (name == null) {
            throw new MissingAttributeException((PMMLObject)simplePredicate, org.dmg.pmml.PMMLAttributes.SIMPLEPREDICATE_FIELD);
        }
        if (simplePredicate.hasValue()) {
            this.parseValue(name, simplePredicate);
        }
        return super.visit(simplePredicate);
    }

    public VisitorAction visit(SimpleSetPredicate simpleSetPredicate) {
        FieldName name = simpleSetPredicate.getField();
        if (name == null) {
            throw new MissingAttributeException((PMMLObject)simpleSetPredicate, org.dmg.pmml.PMMLAttributes.SIMPLESETPREDICATE_FIELD);
        }
        Array array = simpleSetPredicate.getArray();
        if (array == null) {
            throw new MissingElementException((PMMLObject)simpleSetPredicate, PMMLElements.SIMPLESETPREDICATE_ARRAY);
        }
        DataType dataType = this.getDataType(name);
        if (dataType == null) {
            return super.visit(simpleSetPredicate);
        }
        Object value = array.getValue();
        Set values = value instanceof List ? new LinkedHashSet((List)value) : (value instanceof Set ? (Set)value : new LinkedHashSet(ArrayUtil.parse((Array)array)));
        try {
            array = new RichComplexArray(dataType).setType(array.getType()).setValue(values);
        }
        catch (IllegalArgumentException | TypeCheckException e) {
            if (Mode.LOOSE.equals((Object)this.mode)) {
                return super.visit(simpleSetPredicate);
            }
            throw e;
        }
        simpleSetPredicate.setArray(array);
        return super.visit(simpleSetPredicate);
    }

    public VisitorAction visit(TargetValue targetValue) {
        return super.visit(targetValue);
    }

    public VisitorAction visit(TargetValueCount targetValueCount) {
        return super.visit(targetValueCount);
    }

    public VisitorAction visit(Value value) {
        Field field;
        DataType dataType;
        PMMLObject parent = this.getParent();
        Object simpleValue = value.getValue();
        if (simpleValue == null) {
            throw new MissingAttributeException((PMMLObject)value, org.dmg.pmml.PMMLAttributes.VALUE_VALUE);
        }
        if (parent instanceof Field && (dataType = (field = (Field)parent).getDataType()) != null) {
            simpleValue = this.safeParseOrCast(dataType, simpleValue);
            value.setValue(simpleValue);
        }
        return super.visit(value);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = Objects.requireNonNull(mode);
    }

    private <E extends PMMLObject> void parseValue(FieldName name, E hasValue) {
        DataType dataType = this.dataTypes.get(name);
        if (dataType == null) {
            dataType = this.getDataType(name);
            if (dataType == null) {
                return;
            }
            this.dataTypes.put(name, dataType);
        }
        this.parseValue(dataType, hasValue);
    }

    private <E extends PMMLObject> void parseValue(DataType dataType, E hasValue) {
        Object value = ((HasValue)hasValue).getValue();
        if (value == null) {
            throw new MissingAttributeException(MissingAttributeException.formatMessage((String)(XPathUtil.formatElement(hasValue.getClass()) + "@value")), hasValue);
        }
        value = this.parseOrCast(dataType, value);
        ((HasValue)hasValue).setValue(value);
    }

    private DataType getDataType(FieldName name) {
        DataType dataType = null;
        Collection fields = this.getFields();
        for (Field field : fields) {
            if (!name.equals((Object)field.getName())) continue;
            if (dataType == null || dataType.equals((Object)field.getDataType())) {
                dataType = field.getDataType();
                continue;
            }
            return null;
        }
        return dataType;
    }

    private Object parseOrCast(DataType dataType, Object value) {
        try {
            return TypeUtil.parseOrCast((DataType)dataType, (Object)value);
        }
        catch (IllegalArgumentException | TypeCheckException e) {
            if (Mode.LOOSE.equals((Object)this.mode)) {
                return value;
            }
            throw e;
        }
    }

    private Object safeParseOrCast(DataType dataType, Object value) {
        try {
            return TypeUtil.parseOrCast((DataType)dataType, (Object)value);
        }
        catch (IllegalArgumentException | TypeCheckException e) {
            return value;
        }
    }

    public static enum Mode {
        LOOSE,
        STRICT;

    }
}

