/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlTransient;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.MapHolder;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.model.ReflectionUtil;

public class RichDataField
extends DataField
implements MapHolder<Value> {
    @XmlTransient
    private Map<?, Value> valueMap = null;

    public RichDataField() {
    }

    public RichDataField(DataField dataField) {
        ReflectionUtil.copyState((PMMLObject)dataField, (PMMLObject)this);
    }

    public DataType getDataType() {
        DataType dataType = super.getDataType();
        if (dataType == null) {
            throw new MissingAttributeException((PMMLObject)this, PMMLAttributes.DATAFIELD_DATATYPE);
        }
        return dataType;
    }

    public Map<?, Value> getMap() {
        if (this.valueMap == null) {
            this.valueMap = ImmutableMap.copyOf(this.parseValues());
        }
        return this.valueMap;
    }

    private Map<Object, Value> parseValues() {
        DataType dataType = this.getDataType();
        LinkedHashMap<Object, Value> result = new LinkedHashMap<Object, Value>();
        List pmmlValues = this.getValues();
        block6: for (Value pmmlValue : pmmlValues) {
            Object objectValue = pmmlValue.getValue();
            if (objectValue == null) {
                throw new MissingAttributeException((PMMLObject)pmmlValue, PMMLAttributes.VALUE_VALUE);
            }
            Value.Property property = pmmlValue.getProperty();
            switch (property) {
                case VALID: {
                    Object value = TypeUtil.parseOrCast((DataType)dataType, (Object)objectValue);
                    result.put(value, pmmlValue);
                    continue block6;
                }
                case INVALID: 
                case MISSING: {
                    Object value;
                    try {
                        value = TypeUtil.parseOrCast((DataType)dataType, (Object)objectValue);
                    }
                    catch (IllegalArgumentException | TypeCheckException e) {
                        continue block6;
                    }
                    result.put(value, pmmlValue);
                    continue block6;
                }
            }
            throw new UnsupportedAttributeException((PMMLObject)pmmlValue, (Enum)property);
        }
        return result;
    }
}

