/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.naive_bayes;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlTransient;
import org.dmg.pmml.DataType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.naive_bayes.BayesInput;
import org.dmg.pmml.naive_bayes.PMMLAttributes;
import org.dmg.pmml.naive_bayes.PMMLElements;
import org.dmg.pmml.naive_bayes.PairCounts;
import org.dmg.pmml.naive_bayes.TargetValueCounts;
import org.jpmml.evaluator.MapHolder;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.model.ReflectionUtil;

public class RichBayesInput
extends BayesInput
implements MapHolder<TargetValueCounts> {
    @XmlTransient
    private DataType dataType = null;
    @XmlTransient
    private Map<?, TargetValueCounts> targetValueCountMap = null;

    public RichBayesInput(DataType dataType) {
        this.setDataType(dataType);
    }

    public RichBayesInput(DataType dataType, BayesInput bayesInput) {
        this.setDataType(dataType);
        ReflectionUtil.copyState((PMMLObject)bayesInput, (PMMLObject)this);
    }

    public Map<?, TargetValueCounts> getMap() {
        if (this.targetValueCountMap == null) {
            this.targetValueCountMap = ImmutableMap.copyOf(this.parsePairCounts());
        }
        return this.targetValueCountMap;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    private void setDataType(DataType dataType) {
        this.dataType = Objects.requireNonNull(dataType);
    }

    private Map<?, TargetValueCounts> parsePairCounts() {
        DataType dataType = this.getDataType();
        LinkedHashMap<Object, TargetValueCounts> result = new LinkedHashMap<Object, TargetValueCounts>();
        List pairCounts = this.getPairCounts();
        for (PairCounts pairCount : pairCounts) {
            Object category = pairCount.getValue();
            if (category == null) {
                throw new MissingAttributeException((PMMLObject)pairCount, PMMLAttributes.PAIRCOUNTS_VALUE);
            }
            Object value = TypeUtil.parseOrCast((DataType)dataType, (Object)category);
            TargetValueCounts targetValueCounts = pairCount.getTargetValueCounts();
            if (targetValueCounts == null) {
                throw new MissingElementException((PMMLObject)pairCount, PMMLElements.PAIRCOUNTS_TARGETVALUECOUNTS);
            }
            result.put(value, targetValueCounts);
        }
        return result;
    }
}

