/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Objects;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.JavaSimplePredicate;

public abstract class JavaEqualityPredicate
extends JavaSimplePredicate {
    private FieldValue value = null;

    JavaEqualityPredicate(int index, FieldValue value) {
        super(index);
        this.setValue(value);
    }

    public abstract Boolean evaluate(boolean var1);

    public Boolean evaluate(EvaluationContext context) {
        FieldValue value = context.lookup(this.getIndex());
        if (Objects.equals(FieldValues.MISSING_VALUE, value)) {
            return null;
        }
        return this.evaluate(value.equalsValue(this.getValue()));
    }

    public FieldValue getValue() {
        return this.value;
    }

    private void setValue(FieldValue value) {
        this.value = value;
    }

    public static class NotEqual
    extends JavaEqualityPredicate {
        public NotEqual(int index, FieldValue value) {
            super(index, value);
        }

        @Override
        public Boolean evaluate(boolean equals) {
            return !equals;
        }
    }

    public static class Equal
    extends JavaEqualityPredicate {
        public Equal(int index, FieldValue value) {
            super(index, value);
        }

        @Override
        public Boolean evaluate(boolean equals) {
            return equals;
        }
    }
}

