/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.naive_bayes;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.naive_bayes.BayesInput;
import org.dmg.pmml.naive_bayes.PairCounts;
import org.dmg.pmml.naive_bayes.TargetValueCounts;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.HasParsedValueMapping;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.PMMLAttributes;
import org.jpmml.evaluator.PMMLElements;
import org.jpmml.evaluator.TypeInfo;
import org.jpmml.model.ReflectionUtil;

@XmlRootElement(name="BayesInput")
public class RichBayesInput
extends BayesInput
implements HasParsedValueMapping<TargetValueCounts> {
    @XmlTransient
    private Map<FieldValue, TargetValueCounts> parsedValueMappings = null;

    public RichBayesInput() {
    }

    public RichBayesInput(BayesInput bayesInput) {
        ReflectionUtil.copyState((PMMLObject)bayesInput, (PMMLObject)this);
    }

    public Map<FieldValue, TargetValueCounts> getValueMapping(TypeInfo typeInfo) {
        if (this.parsedValueMappings == null) {
            this.parsedValueMappings = ImmutableMap.copyOf(this.parsePairCounts(typeInfo));
        }
        return this.parsedValueMappings;
    }

    private Map<FieldValue, TargetValueCounts> parsePairCounts(TypeInfo typeInfo) {
        LinkedHashMap<FieldValue, TargetValueCounts> result = new LinkedHashMap<FieldValue, TargetValueCounts>();
        List pairCounts = this.getPairCounts();
        for (PairCounts pairCount : pairCounts) {
            String category = pairCount.getValue();
            if (category == null) {
                throw new MissingAttributeException((PMMLObject)pairCount, PMMLAttributes.PAIRCOUNTS_VALUE);
            }
            FieldValue value = this.parse(typeInfo, category);
            TargetValueCounts targetValueCounts = pairCount.getTargetValueCounts();
            if (targetValueCounts == null) {
                throw new MissingElementException((PMMLObject)pairCount, PMMLElements.PAIRCOUNTS_TARGETVALUECOUNTS);
            }
            result.put(value, targetValueCounts);
        }
        return result;
    }
}

