/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.JavaSimplePredicate;

public abstract class JavaComparisonPredicate
extends JavaSimplePredicate {
    private FieldValue value = null;

    JavaComparisonPredicate(int index, FieldValue value) {
        super(index);
        this.setValue(value);
    }

    public abstract Boolean evaluate(int var1);

    public Boolean evaluate(EvaluationContext context) {
        FieldValue value = context.evaluate(this.getIndex());
        if (FieldValueUtil.isMissing((FieldValue)value)) {
            return null;
        }
        return this.evaluate(value.compareToValue(this.getValue()));
    }

    public FieldValue getValue() {
        return this.value;
    }

    private void setValue(FieldValue value) {
        this.value = value;
    }

    public static class LessThan
    extends JavaComparisonPredicate {
        public LessThan(int index, FieldValue value) {
            super(index, value);
        }

        @Override
        public Boolean evaluate(int order) {
            return order < 0;
        }
    }

    public static class LessOrEqual
    extends JavaComparisonPredicate {
        public LessOrEqual(int index, FieldValue value) {
            super(index, value);
        }

        @Override
        public Boolean evaluate(int order) {
            return order <= 0;
        }
    }

    public static class GreaterThan
    extends JavaComparisonPredicate {
        public GreaterThan(int index, FieldValue value) {
            super(index, value);
        }

        @Override
        public Boolean evaluate(int order) {
            return order > 0;
        }
    }

    public static class GreaterOrEqual
    extends JavaComparisonPredicate {
        public GreaterOrEqual(int index, FieldValue value) {
            super(index, value);
        }

        @Override
        public Boolean evaluate(int order) {
            return order >= 0;
        }
    }
}

