/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import java.util.Collection;
import java.util.List;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.ComplexDoubleVector;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.FunctionException;
import org.jpmml.evaluator.TypeInfo;
import org.jpmml.evaluator.TypeInfos;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.functions.AbstractFunction;

public class PercentileFunction
extends AbstractFunction {
    public PercentileFunction() {
        this(PercentileFunction.class.getName());
    }

    public PercentileFunction(String name) {
        super(name);
    }

    public FieldValue evaluate(List<FieldValue> arguments) {
        this.checkFixedArityArguments(arguments, 2);
        Collection values = (Collection)FieldValueUtil.getValue(Collection.class, (FieldValue)this.getRequiredArgument(arguments, 0, "values"));
        int percentile = this.getRequiredArgument(arguments, 1, "percentile").asInteger();
        if (percentile < 1 || percentile > 100) {
            throw new FunctionException((Function)this, "Invalid 'percentile' value " + percentile + ". Must be greater than 0 and equal or less than 100");
        }
        Double result = PercentileFunction.evaluate(values, percentile);
        return FieldValueUtil.create((TypeInfo)TypeInfos.CONTINUOUS_DOUBLE, (Object)result);
    }

    private static Double evaluate(Collection<?> values, int percentile) {
        ComplexDoubleVector doubleValues = new ComplexDoubleVector(values.size());
        for (Object value : values) {
            Number number = (Number)TypeUtil.parseOrCast((DataType)DataType.DOUBLE, value);
            doubleValues.add(number.doubleValue());
        }
        return doubleValues.doublePercentile(percentile);
    }
}

