/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.TypeInfo;
import org.jpmml.evaluator.TypeInfos;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.functions.AbstractFunction;

public class StandardDeviationFunction
extends AbstractFunction {
    public StandardDeviationFunction() {
        this(StandardDeviationFunction.class.getName());
    }

    public StandardDeviationFunction(String name) {
        super(name);
    }

    public FieldValue evaluate(List<FieldValue> arguments) {
        this.checkVariableArityArguments(arguments, 1, 2);
        Collection values = (Collection)FieldValueUtil.getValue(Collection.class, (FieldValue)this.getRequiredArgument(arguments, 0, "values"));
        Boolean biasCorrected = Boolean.FALSE;
        if (arguments.size() > 1) {
            biasCorrected = this.getRequiredArgument(arguments, 1, "biasCorrected").asBoolean();
        }
        Double result = StandardDeviationFunction.evaluate(values, biasCorrected);
        return FieldValueUtil.create((TypeInfo)TypeInfos.CONTINUOUS_DOUBLE, (Object)result);
    }

    private static Double evaluate(Collection<?> values, boolean biasCorrected) {
        StandardDeviation statistic = new StandardDeviation();
        statistic.setBiasCorrected(biasCorrected);
        for (Object value : values) {
            Number number = (Number)TypeUtil.parseOrCast((DataType)DataType.DOUBLE, value);
            statistic.increment(number.doubleValue());
        }
        return statistic.getResult();
    }
}

