/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.dmg.pmml.FieldName;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static FieldName[] readFieldNames(DataInput dataInput, int count) throws IOException {
        String[] strings = ResourceUtil.readStrings(dataInput, count);
        FieldName[] result = new FieldName[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            result[i] = FieldName.create((String)string);
        }
        return result;
    }

    public static void writeFieldNames(DataOutput dataOutput, FieldName[] names) throws IOException {
        String[] strings = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            FieldName name = names[i];
            strings[i] = name.getValue();
        }
        ResourceUtil.writeStrings(dataOutput, strings);
    }

    public static QName[] readQNames(DataInput dataInput, int count) throws IOException {
        String[][] stringArrays = ResourceUtil.readStringArrays(dataInput, count, 3);
        QName[] result = new QName[stringArrays.length];
        for (int i = 0; i < stringArrays.length; ++i) {
            String[] stringArray = stringArrays[i];
            result[i] = new QName(stringArray[0], stringArray[1], stringArray[2]);
        }
        return result;
    }

    public static void writeQNames(DataOutput dataOutput, QName[] names) throws IOException {
        String[][] stringArrays = new String[names.length][3];
        for (int i = 0; i < names.length; ++i) {
            QName name = names[i];
            stringArrays[i] = new String[]{name.getNamespaceURI(), name.getLocalPart(), name.getPrefix()};
        }
        ResourceUtil.writeStringArrays(dataOutput, stringArrays);
    }

    public static String[] readStrings(DataInput dataInput, int count) throws IOException {
        String[] result = new String[count];
        for (int i = 0; i < count; ++i) {
            result[i] = dataInput.readUTF();
        }
        return result;
    }

    public static String[][] readStringArrays(DataInput dataInput, int count, int length) throws IOException {
        String[][] result = new String[count][length];
        for (int i = 0; i < count; ++i) {
            result[i] = ResourceUtil.readStrings(dataInput, length);
        }
        return result;
    }

    public static List<String>[] readStringLists(DataInput dataInput) throws IOException {
        int count = dataInput.readInt();
        ArrayList<List<String>> result = new ArrayList<List<String>>(count);
        for (int i = 0; i < count; ++i) {
            int length = dataInput.readInt();
            String[] strings = ResourceUtil.readStrings(dataInput, length);
            result.add(Arrays.asList(strings));
        }
        return result.toArray(new List[result.size()]);
    }

    public static void writeStrings(DataOutput dataOutput, String[] strings) throws IOException {
        for (String string : strings) {
            dataOutput.writeUTF(string);
        }
    }

    public static void writeStringArrays(DataOutput dataOutput, String[][] stringArrays) throws IOException {
        for (String[] stringArray : stringArrays) {
            ResourceUtil.writeStrings(dataOutput, stringArray);
        }
    }

    public static void writeStringLists(DataOutput dataOutput, List<String>[] stringLists) throws IOException {
        int count = stringLists.length;
        dataOutput.writeInt(count);
        for (List<String> stringList : stringLists) {
            int length = stringList.size();
            dataOutput.writeInt(length);
            ResourceUtil.writeStrings(dataOutput, stringList.toArray(new String[length]));
        }
    }

    public static Double[] readDoubles(DataInput dataInput, int count) throws IOException {
        Double[] result = new Double[count];
        for (int i = 0; i < count; ++i) {
            result[i] = dataInput.readDouble();
        }
        return result;
    }

    public static Double[][] readDoubleArrays(DataInput dataInput, int count, int length) throws IOException {
        Double[][] result = new Double[count][length];
        for (int i = 0; i < count; ++i) {
            result[i] = ResourceUtil.readDoubles(dataInput, length);
        }
        return result;
    }

    public static void writeDoubles(DataOutput dataOutput, Number[] numbers) throws IOException {
        for (Number number : numbers) {
            dataOutput.writeDouble(number.doubleValue());
        }
    }

    public static void writeDoubleArrays(DataOutput dataOutput, Number[][] numberArrays) throws IOException {
        for (Number[] numberArray : numberArrays) {
            ResourceUtil.writeDoubles(dataOutput, numberArray);
        }
    }

    public static Float[] readFloats(DataInput dataInput, int count) throws IOException {
        Float[] result = new Float[count];
        for (int i = 0; i < count; ++i) {
            result[i] = Float.valueOf(dataInput.readFloat());
        }
        return result;
    }

    public static Float[][] readFloatArrays(DataInput dataInput, int count, int length) throws IOException {
        Float[][] result = new Float[count][length];
        for (int i = 0; i < count; ++i) {
            result[i] = ResourceUtil.readFloats(dataInput, length);
        }
        return result;
    }

    public static void writeFloats(DataOutput dataOutput, Number[] numbers) throws IOException {
        for (Number number : numbers) {
            dataOutput.writeFloat(number.floatValue());
        }
    }

    public static void writeFloatArrays(DataOutput dataOutput, Number[][] numberArrays) throws IOException {
        for (Number[] numberArray : numberArrays) {
            ResourceUtil.writeFloats(dataOutput, numberArray);
        }
    }
}

