/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Equivalence;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.Computable;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.VerificationUtil;

public class PMMLEquivalence
extends Equivalence<Object> {
    private double precision = 0.0;
    private double zeroThreshold = 0.0;

    public PMMLEquivalence(double precision, double zeroThreshold) {
        this.setPrecision(precision);
        this.setZeroThreshold(zeroThreshold);
    }

    public boolean doEquivalent(Object expected, Object actual) {
        double precision = this.getPrecision();
        double zeroThreshold = this.getZeroThreshold();
        if (actual instanceof Computable) {
            actual = EvaluatorUtil.decode((Object)actual);
        }
        expected = TypeUtil.parseOrCast((DataType)TypeUtil.getDataType((Object)actual), (Object)expected);
        return VerificationUtil.acceptable((Object)expected, (Object)actual, (double)precision, (double)zeroThreshold);
    }

    public int doHash(Object object) {
        throw new UnsupportedOperationException();
    }

    public double getPrecision() {
        return this.precision;
    }

    private void setPrecision(double precision) {
        if (precision < 0.0) {
            throw new IllegalArgumentException();
        }
        this.precision = precision;
    }

    public double getZeroThreshold() {
        return this.zeroThreshold;
    }

    private void setZeroThreshold(double zeroThreshold) {
        if (zeroThreshold < 0.0) {
            throw new IllegalArgumentException();
        }
        this.zeroThreshold = zeroThreshold;
    }
}

