/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Visitable;
import org.jpmml.evaluator.Batch;
import org.jpmml.evaluator.BatchUtil;
import org.jpmml.evaluator.CsvUtil;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorBuilder;
import org.jpmml.evaluator.FieldNameSet;
import org.jpmml.evaluator.FunctionNameStack;
import org.jpmml.evaluator.ModelEvaluatorBuilder;
import org.jpmml.evaluator.SymbolTable;
import org.jpmml.evaluator.visitors.DefaultVisitorBattery;
import org.jpmml.model.PMMLUtil;

public abstract class ArchiveBatch
implements Batch {
    private String name = null;
    private String dataset = null;
    private Predicate<FieldName> predicate = null;

    public ArchiveBatch(String name, String dataset, Predicate<FieldName> predicate) {
        this.setName(name);
        this.setDataset(dataset);
        this.setPredicate(predicate);
    }

    public abstract InputStream open(String var1);

    public EvaluatorBuilder getEvaluatorBuilder() throws Exception {
        PMML pmml = this.getPMML();
        DefaultVisitorBattery visitorBattery = new DefaultVisitorBattery();
        visitorBattery.applyTo((Visitable)pmml);
        ModelEvaluatorBuilder evaluatorBuilder = new ModelEvaluatorBuilder(pmml).setDerivedFieldGuard((SymbolTable)new FieldNameSet(8)).setFunctionGuard((SymbolTable)new FunctionNameStack(4));
        return evaluatorBuilder;
    }

    @Override
    public Evaluator getEvaluator() throws Exception {
        EvaluatorBuilder evaluatorBuilder = this.getEvaluatorBuilder();
        Evaluator evaluator = evaluatorBuilder.build();
        evaluator.verify();
        return evaluator;
    }

    public PMML getPMML() throws Exception {
        return this.loadPMML("/pmml/" + this.getName() + this.getDataset() + ".pmml");
    }

    public List<Map<FieldName, String>> getInput() throws IOException {
        return this.loadRecords("/csv/" + this.getDataset() + ".csv");
    }

    public List<Map<FieldName, String>> getOutput() throws IOException {
        return this.loadRecords("/csv/" + this.getName() + this.getDataset() + ".csv");
    }

    @Override
    public void close() throws Exception {
    }

    protected PMML loadPMML(String path) throws Exception {
        try (InputStream is = this.open(path);){
            PMML pMML = PMMLUtil.unmarshal((InputStream)is);
            return pMML;
        }
    }

    protected List<Map<FieldName, String>> loadRecords(String path) throws IOException {
        CsvUtil.Table table;
        try (InputStream is = this.open(path);){
            table = CsvUtil.readTable(is, ",");
        }
        Function<String, String> function = new Function<String, String>(){

            @Override
            public String apply(String string) {
                if ("N/A".equals(string) || "NA".equals(string)) {
                    return null;
                }
                return string;
            }
        };
        return BatchUtil.parseRecords(table, function);
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public String getDataset() {
        return this.dataset;
    }

    private void setDataset(String dataset) {
        this.dataset = dataset;
    }

    @Override
    public Predicate<FieldName> getPredicate() {
        return this.predicate;
    }

    private void setPredicate(Predicate<FieldName> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException();
        }
        this.predicate = predicate;
    }
}

