/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.dmg.pmml.Application;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.evaluator.ArchiveBatch;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorBuilder;
import org.jpmml.evaluator.IntegrationTest;
import org.jpmml.evaluator.ModelEvaluatorBuilder;
import org.jpmml.evaluator.OutputFilters;
import org.jpmml.evaluator.visitors.InvalidMarkupInspector;
import org.jpmml.evaluator.visitors.UnsupportedMarkupInspector;
import org.jpmml.model.visitors.LocatorTransformer;

public abstract class IntegrationTestBatch
extends ArchiveBatch {
    private Evaluator evaluator = null;

    public IntegrationTestBatch(String name, String dataset, Predicate<FieldName> predicate) {
        super(name, dataset, predicate);
    }

    public abstract IntegrationTest getIntegrationTest();

    @Override
    public InputStream open(String path) {
        IntegrationTest integrationTest = this.getIntegrationTest();
        Class<?> clazz = integrationTest.getClass();
        return clazz.getResourceAsStream(path);
    }

    @Override
    public EvaluatorBuilder getEvaluatorBuilder() throws Exception {
        ModelEvaluatorBuilder modelEvaluatorBuilder = (ModelEvaluatorBuilder)super.getEvaluatorBuilder();
        modelEvaluatorBuilder.setOutputFilter(OutputFilters.KEEP_FINAL_RESULTS);
        return modelEvaluatorBuilder;
    }

    @Override
    public Evaluator getEvaluator() throws Exception {
        if (this.evaluator == null) {
            Evaluator evaluator = super.getEvaluator();
            IntegrationTestBatch.ensureSerializability(evaluator);
            this.evaluator = evaluator;
        }
        return this.evaluator;
    }

    @Override
    public PMML getPMML() throws Exception {
        PMML pmml = super.getPMML();
        LocatorTransformer locatorTransformer = new LocatorTransformer();
        locatorTransformer.applyTo((Visitable)pmml);
        return pmml;
    }

    @Override
    public void close() throws Exception {
        if (this.evaluator != null) {
            try {
                IntegrationTestBatch.ensureSerializability(this.evaluator);
            }
            finally {
                this.evaluator = null;
            }
        }
    }

    protected static void ensureValidity(PMMLObject object) {
        List<Visitor> visitors = Arrays.asList(new UnsupportedMarkupInspector(), new InvalidMarkupInspector(){

            public VisitorAction visit(Application application) {
                String name = application.getName();
                if (name == null) {
                    return VisitorAction.SKIP;
                }
                return super.visit(application);
            }

            public VisitorAction visit(MiningSchema miningSchema) {
                if (!miningSchema.hasMiningFields()) {
                    return VisitorAction.SKIP;
                }
                return super.visit(miningSchema);
            }
        });
        for (Visitor visitor : visitors) {
            visitor.applyTo((Visitable)object);
        }
    }

    protected static void ensureSerializability(Object object) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(ByteStreams.nullOutputStream());){
            oos.writeObject(object);
        }
    }
}

