/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Equivalence;
import java.util.List;
import org.jpmml.evaluator.Batch;
import org.jpmml.evaluator.BatchUtil;
import org.jpmml.evaluator.Conflict;
import org.junit.Assert;

public abstract class BatchTest {
    private Equivalence<Object> equivalence = null;

    public BatchTest(Equivalence<Object> equivalence) {
        this.setEquivalence(equivalence);
    }

    public void evaluate(Batch batch, Equivalence<Object> equivalence) throws Exception {
        List<Conflict> conflicts;
        if (equivalence == null) {
            equivalence = this.getEquivalence();
        }
        if ((conflicts = BatchUtil.evaluate(batch, equivalence)).size() > 0) {
            for (Conflict conflict : conflicts) {
                this.log(conflict);
            }
            Assert.fail((String)("Found " + conflicts.size() + " conflict(s)"));
        }
    }

    public void log(Conflict conflict) {
        System.err.println(conflict);
    }

    public Equivalence<Object> getEquivalence() {
        return this.equivalence;
    }

    private void setEquivalence(Equivalence<Object> equivalence) {
        if (equivalence == null) {
            throw new IllegalArgumentException();
        }
        this.equivalence = equivalence;
    }
}

