/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Equivalence;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.Batch;
import org.jpmml.evaluator.BatchTest;
import org.jpmml.evaluator.IntegrationTestBatch;

public abstract class IntegrationTest
extends BatchTest {
    public IntegrationTest(Equivalence<Object> equivalence) {
        super(equivalence);
    }

    public void evaluate(String name, String dataset) throws Exception {
        this.evaluate(name, dataset, x -> true, null);
    }

    public void evaluate(String name, String dataset, Equivalence<Object> equivalence) throws Exception {
        this.evaluate(name, dataset, x -> true, equivalence);
    }

    public void evaluate(String name, String dataset, Predicate<FieldName> predicate) throws Exception {
        this.evaluate(name, dataset, predicate, null);
    }

    public void evaluate(String name, String dataset, Predicate<FieldName> predicate, Equivalence<Object> equivalence) throws Exception {
        try (Batch batch = this.createBatch(name, dataset, predicate);){
            this.evaluate(batch, equivalence);
        }
    }

    protected Batch createBatch(String name, String dataset, Predicate<FieldName> predicate) {
        IntegrationTestBatch result = new IntegrationTestBatch(name, dataset, predicate){

            @Override
            public IntegrationTest getIntegrationTest() {
                return IntegrationTest.this;
            }
        };
        return result;
    }

    public static Predicate<FieldName> excludeFields(FieldName ... names) {
        return IntegrationTest.excludeFields(Arrays.asList(names));
    }

    public static Predicate<FieldName> excludeFields(final Collection<FieldName> names) {
        Predicate<FieldName> predicate = new Predicate<FieldName>(){

            @Override
            public boolean test(FieldName name) {
                return !names.contains(name);
            }
        };
        return predicate;
    }
}

