/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.ArrayType;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.manager.UnsupportedFeatureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayUtil {
    private ArrayUtil() {
    }

    public static Boolean isIn(ArrayType array, Object value) {
        List<String> values = ArrayUtil.tokenize(array);
        boolean result = values.contains(String.valueOf(value));
        return result;
    }

    public static Boolean isNotIn(ArrayType array, Object value) {
        List<String> values = ArrayUtil.tokenize(array);
        boolean result = !values.contains(String.valueOf(value));
        return result;
    }

    public static List<String> tokenize(ArrayType array) {
        List<String> result;
        ArrayType.Type type = array.getType();
        switch (type) {
            case INT: 
            case REAL: {
                result = ArrayUtil.tokenize(array.getContent(), false);
                break;
            }
            case STRING: {
                result = ArrayUtil.tokenize(array.getContent(), true);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((Enum)type);
            }
        }
        BigInteger n = array.getN();
        if (n != null && ((Number)n).intValue() != result.size()) {
            throw new EvaluationException();
        }
        return result;
    }

    private static List<String> tokenize(String string, boolean enableQuotes) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        boolean quoted = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (quoted) {
                if (c == '\\' && i < string.length() - 1) {
                    c = string.charAt(i + 1);
                    if (c == '\"') {
                        sb.append('\"');
                        ++i;
                        continue;
                    }
                    sb.append('\\');
                    continue;
                }
                sb.append(c);
                if (c != '\"') continue;
                result.add(ArrayUtil.createToken(sb, enableQuotes));
                quoted = false;
                continue;
            }
            if (c == '\"' && enableQuotes) {
                if (sb.length() > 0) {
                    result.add(ArrayUtil.createToken(sb, enableQuotes));
                }
                sb.append('\"');
                quoted = true;
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (sb.length() <= 0) continue;
                result.add(ArrayUtil.createToken(sb, enableQuotes));
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            result.add(ArrayUtil.createToken(sb, enableQuotes));
        }
        return result;
    }

    private static String createToken(StringBuffer sb, boolean enableQuotes) {
        String result = sb.length() > 1 && sb.charAt(0) == '\"' && sb.charAt(sb.length() - 1) == '\"' && enableQuotes ? sb.substring(1, sb.length() - 1) : sb.substring(0, sb.length());
        sb.setLength(0);
        return result;
    }
}

