/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import java.util.Map;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.Interval;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TableLocator;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.ParameterUtil;
import org.jpmml.evaluator.TableUtil;
import org.jpmml.manager.UnsupportedFeatureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscretizationUtil {
    private DiscretizationUtil() {
    }

    public static String discretize(Discretize discretize, Object value) {
        Double doubleValue = ParameterUtil.toDouble(value);
        List bins = discretize.getDiscretizeBins();
        for (DiscretizeBin bin : bins) {
            Interval interval = bin.getInterval();
            if (!DiscretizationUtil.contains(interval, doubleValue)) continue;
            return bin.getBinValue();
        }
        return discretize.getDefaultValue();
    }

    public static boolean contains(Interval interval, Double value) {
        Double left = interval.getLeftMargin();
        Double right = interval.getRightMargin();
        Interval.Closure closure = interval.getClosure();
        switch (closure) {
            case OPEN_CLOSED: {
                return DiscretizationUtil.greaterThan(left, value) && DiscretizationUtil.lessOrEqual(right, value);
            }
            case OPEN_OPEN: {
                return DiscretizationUtil.greaterThan(left, value) && DiscretizationUtil.lessThan(right, value);
            }
            case CLOSED_OPEN: {
                return DiscretizationUtil.greaterOrEqual(left, value) && DiscretizationUtil.lessThan(right, value);
            }
            case CLOSED_CLOSED: {
                return DiscretizationUtil.greaterOrEqual(left, value) && DiscretizationUtil.lessOrEqual(right, value);
            }
        }
        throw new UnsupportedFeatureException((Enum)closure);
    }

    private static boolean lessThan(Double reference, Double value) {
        return reference != null ? value.compareTo(reference) < 0 : true;
    }

    private static boolean lessOrEqual(Double reference, Double value) {
        return reference != null ? value.compareTo(reference) <= 0 : true;
    }

    private static boolean greaterThan(Double reference, Double value) {
        return reference != null ? value.compareTo(reference) > 0 : true;
    }

    private static boolean greaterOrEqual(Double reference, Double value) {
        return reference != null ? value.compareTo(reference) >= 0 : true;
    }

    public static String mapValue(MapValues mapValues, Map<String, Object> values) {
        InlineTable table = mapValues.getInlineTable();
        if (table != null) {
            List<Map<String, String>> rows = TableUtil.parse(table);
            Map<String, String> row = TableUtil.match(rows, values);
            if (row != null) {
                String result = row.get(mapValues.getOutputColumn());
                if (result == null) {
                    throw new EvaluationException();
                }
                return result;
            }
        } else {
            TableLocator tableLocator = mapValues.getTableLocator();
            if (tableLocator != null) {
                throw new UnsupportedFeatureException((PMMLObject)tableLocator);
            }
        }
        return mapValues.getDefaultValue();
    }
}

