/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.ResultFeatureType;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.ModelManagerEvaluationContext;
import org.jpmml.manager.ModelManager;
import org.jpmml.manager.UnsupportedFeatureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputUtil {
    private OutputUtil() {
    }

    public static <M extends Model> Map<FieldName, Object> evaluate(ModelManager<M> modelManager, Map<FieldName, ?> parameters, Map<FieldName, ?> predictions) {
        LinkedHashMap<FieldName, Object> result = new LinkedHashMap<FieldName, Object>();
        if (!Collections.disjoint(parameters.keySet(), predictions.keySet())) {
            throw new EvaluationException();
        }
        result.putAll(predictions);
        LinkedHashMap<FieldName, Object> values = new LinkedHashMap<FieldName, Object>();
        values.putAll(parameters);
        values.putAll(EvaluatorUtil.decodeValues(predictions));
        ModelManagerEvaluationContext context = new ModelManagerEvaluationContext(modelManager, values);
        Output output = modelManager.getOrCreateOutput();
        List outputFields = output.getOutputFields();
        for (OutputField outputField : outputFields) {
            Object value;
            ResultFeatureType resultFeature = outputField.getFeature();
            switch (resultFeature) {
                case PREDICTED_VALUE: {
                    FieldName target = outputField.getTargetField();
                    if (target == null) {
                        target = modelManager.getTarget();
                    }
                    if (!predictions.containsKey(target)) {
                        throw new EvaluationException();
                    }
                    value = values.get(target);
                    break;
                }
                case TRANSFORMED_VALUE: {
                    Expression expression = outputField.getExpression();
                    if (expression == null) {
                        throw new EvaluationException();
                    }
                    value = ExpressionUtil.evaluate(expression, (EvaluationContext)context);
                    break;
                }
                default: {
                    throw new UnsupportedFeatureException((Enum)resultFeature);
                }
            }
            FieldName name = outputField.getName();
            result.put(name, value);
            values.put(name, EvaluatorUtil.decode(value));
        }
        return result;
    }
}

