/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningField;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.manager.UnsupportedFeatureException;

public class ParameterUtil {
    private ParameterUtil() {
    }

    public static Object prepare(DataField dataField, MiningField miningField, String string) {
        if (string == null) {
            return null;
        }
        return ParameterUtil.parse(dataField.getDataType(), string);
    }

    public static Object parse(DataType dataType, String string) {
        switch (dataType) {
            case STRING: {
                return string;
            }
            case INTEGER: {
                return new Integer(string);
            }
            case FLOAT: {
                return new Float(string);
            }
            case DOUBLE: {
                return new Double(string);
            }
        }
        throw new UnsupportedFeatureException((Enum)dataType);
    }

    public static String toString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.toString();
        }
        throw new EvaluationException();
    }

    public static Double toDouble(Object value) {
        if (value instanceof String) {
            String string = (String)value;
            return Double.valueOf(string);
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        throw new EvaluationException();
    }

    public static DataType getDataType(Object object) {
        if (object instanceof String) {
            return DataType.STRING;
        }
        if (object instanceof Integer) {
            return DataType.INTEGER;
        }
        if (object instanceof Float) {
            return DataType.FLOAT;
        }
        if (object instanceof Double) {
            return DataType.DOUBLE;
        }
        throw new UnsupportedFeatureException();
    }

    public static DataType getDataType(String string) {
        try {
            if (string.indexOf(46) > -1) {
                Float.parseFloat(string);
                return DataType.FLOAT;
            }
            Integer.parseInt(string);
            return DataType.INTEGER;
        }
        catch (NumberFormatException nfe) {
            return DataType.STRING;
        }
    }
}

