/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.NoTrueChildStrategyType;
import org.dmg.pmml.Node;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.TreeModel;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.ModelManagerEvaluationContext;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.ParameterUtil;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.manager.ModelManager;
import org.jpmml.manager.TreeModelManager;
import org.jpmml.manager.UnsupportedFeatureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeModelEvaluator
extends TreeModelManager
implements Evaluator {
    public TreeModelEvaluator(PMML pmml) {
        super(pmml);
    }

    public TreeModelEvaluator(PMML pmml, TreeModel treeModel) {
        super(pmml, treeModel);
    }

    public TreeModelEvaluator(TreeModelManager parent) {
        this(parent.getPmml(), parent.getModel());
    }

    @Override
    public Object prepare(FieldName name, String string) {
        return ParameterUtil.prepare(this.getDataField(name), this.getMiningField(name), string);
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> parameters) {
        ModelManagerEvaluationContext context = new ModelManagerEvaluationContext((ModelManager<?>)this, parameters);
        String score = null;
        Node node = this.evaluateTree(context);
        if (node != null && (score = node.getScore()) == null) {
            score = this.computeScore(node);
        }
        Map<FieldName, String> predictions = Collections.singletonMap(this.getTarget(), score);
        return OutputUtil.evaluate(this, parameters, predictions);
    }

    public Node evaluateTree(EvaluationContext context) {
        Node root = this.getOrCreateRoot();
        Prediction prediction = this.findTrueChild(root, root, context);
        if (prediction.getLastTrueNode() != null && prediction.getTrueNode() != null && !prediction.getLastTrueNode().equals((Object)prediction.getTrueNode())) {
            return prediction.getTrueNode();
        }
        NoTrueChildStrategyType noTrueChildStrategy = this.getModel().getNoTrueChildStrategy();
        switch (noTrueChildStrategy) {
            case RETURN_NULL_PREDICTION: {
                return null;
            }
            case RETURN_LAST_PREDICTION: {
                return prediction.getLastTrueNode();
            }
        }
        throw new UnsupportedFeatureException((Enum)noTrueChildStrategy);
    }

    private Prediction findTrueChild(Node lastNode, Node node, EvaluationContext context) {
        Boolean value = this.evaluateNode(node, context);
        if (value == null) {
            throw new EvaluationException();
        }
        if (value.booleanValue()) {
            List children = node.getNodes();
            for (Node child : children) {
                Prediction childPrediction = this.findTrueChild(node, child, context);
                if (childPrediction.getTrueNode() == null) continue;
                return childPrediction;
            }
            return new Prediction(lastNode, node);
        }
        return new Prediction(lastNode, null);
    }

    private Boolean evaluateNode(Node node, EvaluationContext context) {
        Predicate predicate = node.getPredicate();
        if (predicate == null) {
            throw new EvaluationException();
        }
        return PredicateUtil.evaluatePredicate(predicate, context);
    }

    private String computeScore(Node node) {
        ScoreDistribution result = null;
        List scoreDistributions = node.getScoreDistributions();
        for (ScoreDistribution scoreDistribution : scoreDistributions) {
            if (result != null && !(result.getRecordCount() < scoreDistribution.getRecordCount())) continue;
            result = scoreDistribution;
        }
        return result != null ? result.getValue() : null;
    }

    private static class Prediction {
        private Node lastTrueNode = null;
        private Node trueNode = null;

        public Prediction(Node lastTrueNode, Node trueNode) {
            this.lastTrueNode = lastTrueNode;
            this.trueNode = trueNode;
        }

        public Node getLastTrueNode() {
            return this.lastTrueNode;
        }

        public Node getTrueNode() {
            return this.trueNode;
        }
    }
}

