/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.IOUtil;
import org.dmg.pmml.PMML;
import org.jpmml.evaluator.Batch;
import org.jpmml.evaluator.CsvUtil;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.evaluator.ParameterUtil;
import org.jpmml.evaluator.VerificationUtil;
import org.jpmml.manager.ModelManager;
import org.jpmml.manager.ModelManagerFactory;
import org.jpmml.manager.PMMLManager;

public class BatchUtil {
    private static final double precision = 1.0E-6;
    private static final double zeroThreshold = 1.0E-6;

    private BatchUtil() {
    }

    public static boolean evaluate(Batch batch) throws Exception {
        PMML pmml = IOUtil.unmarshal((InputStream)batch.getModel());
        PMMLManager pmmlManager = new PMMLManager(pmml);
        ModelManager modelManager = pmmlManager.getModelManager(null, (ModelManagerFactory)ModelEvaluatorFactory.getInstance());
        List<Map<FieldName, String>> input = CsvUtil.load(batch.getInput());
        List<Map<FieldName, String>> output = CsvUtil.load(batch.getOutput());
        Evaluator evaluator = (Evaluator)modelManager;
        List<LinkedHashMap> table = Lists.newArrayList();
        List activeFields = evaluator.getActiveFields();
        List groupFields = evaluator.getGroupFields();
        List predictedFields = evaluator.getPredictedFields();
        List outputFields = evaluator.getOutputFields();
        ArrayList inputFields = Lists.newArrayList();
        inputFields.addAll(activeFields);
        inputFields.addAll(groupFields);
        for (int i = 0; i < input.size(); ++i) {
            Map<FieldName, String> inputRow = input.get(i);
            LinkedHashMap arguments = Maps.newLinkedHashMap();
            for (FieldName inputField : inputFields) {
                String inputCell = inputRow.get(inputField);
                Object inputValue = evaluator.prepare(inputField, (Object)inputCell);
                arguments.put(inputField, inputValue);
            }
            table.add(arguments);
        }
        if (groupFields.size() == 1) {
            FieldName groupField = (FieldName)groupFields.get(0);
            table = EvaluatorUtil.groupRows((FieldName)groupField, (List)table);
        } else if (groupFields.size() > 1) {
            throw new EvaluationException();
        }
        if (output.isEmpty()) {
            for (int i = 0; i < table.size(); ++i) {
                Map arguments = (Map)table.get(i);
                evaluator.evaluate(arguments);
            }
            return true;
        }
        if (table.size() != output.size()) {
            throw new EvaluationException();
        }
        boolean success = true;
        for (int i = 0; i < output.size(); ++i) {
            String outputCell;
            Map<FieldName, String> outputRow = output.get(i);
            Map arguments = (Map)table.get(i);
            Map result = evaluator.evaluate(arguments);
            for (FieldName predictedField : predictedFields) {
                outputCell = outputRow.get(predictedField);
                Object predictedValue = EvaluatorUtil.decode(result.get(predictedField));
                success &= BatchUtil.acceptable(outputCell, predictedValue);
            }
            for (FieldName outputField : outputFields) {
                outputCell = outputRow.get(outputField);
                Object computedValue = result.get(outputField);
                success &= outputCell != null ? BatchUtil.acceptable(outputCell, computedValue) : BatchUtil.acceptable(computedValue);
            }
        }
        return success;
    }

    private static boolean acceptable(Object actual) {
        return actual != null;
    }

    private static boolean acceptable(String expected, Object actual) {
        return VerificationUtil.acceptable((Object)ParameterUtil.parse((DataType)ParameterUtil.getDataType((Object)actual), (String)expected), (Object)actual, (double)1.0E-6, (double)1.0E-6);
    }
}

