/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.jpmml.evaluator.VerificationUtil;
import org.junit.Assert;
import org.junit.Test;

public class VerificationUtilTest {
    @Test
    public void acceptable() {
        double precision = 0.001;
        double zeroThreshold = precision * precision;
        Assert.assertTrue((boolean)VerificationUtil.acceptable((Number)1.0, (Number)1.0, (double)precision, (double)zeroThreshold));
        Assert.assertTrue((boolean)VerificationUtil.acceptable((Number)1.0, (Number)0.999, (double)precision, (double)zeroThreshold));
        Assert.assertFalse((boolean)VerificationUtil.acceptable((Number)1.0, (Number)0.99895, (double)precision, (double)zeroThreshold));
        Assert.assertTrue((boolean)VerificationUtil.acceptable((Number)1.0, (Number)1.001, (double)precision, (double)zeroThreshold));
        Assert.assertFalse((boolean)VerificationUtil.acceptable((Number)1.0, (Number)1.00105, (double)precision, (double)zeroThreshold));
        Assert.assertTrue((boolean)VerificationUtil.acceptable((Number)-1.0, (Number)-1.0, (double)precision, (double)zeroThreshold));
        Assert.assertTrue((boolean)VerificationUtil.acceptable((Number)-1.0, (Number)-1.001, (double)precision, (double)zeroThreshold));
        Assert.assertFalse((boolean)VerificationUtil.acceptable((Number)-1.0, (Number)-1.00105, (double)precision, (double)zeroThreshold));
        Assert.assertTrue((boolean)VerificationUtil.acceptable((Number)-1.0, (Number)-0.999, (double)precision, (double)zeroThreshold));
        Assert.assertFalse((boolean)VerificationUtil.acceptable((Number)-1.0, (Number)-0.99895, (double)precision, (double)zeroThreshold));
    }

    @Test
    public void isZero() {
        double zeroThreshold = 0.001;
        Assert.assertTrue((boolean)VerificationUtil.isZero((Number)5.0E-4, (double)zeroThreshold));
        Assert.assertTrue((boolean)VerificationUtil.isZero((Number)0, (double)zeroThreshold));
        Assert.assertTrue((boolean)VerificationUtil.isZero((Number)-5.0E-4, (double)zeroThreshold));
        Assert.assertFalse((boolean)VerificationUtil.isZero((Number)0.0015, (double)zeroThreshold));
        Assert.assertFalse((boolean)VerificationUtil.isZero((Number)-0.0015, (double)zeroThreshold));
    }
}

