/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jpmml.evaluator.Computable;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.HasConfidence;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.MissingResultException;

class ClassificationMap
extends LinkedHashMap<String, Double>
implements Computable<String>,
HasConfidence,
HasProbability {
    private Type type = null;

    ClassificationMap(Type type) {
        this.setType(type);
    }

    @Override
    public String getResult() {
        Map.Entry result = null;
        Set entries = this.entrySet();
        for (Map.Entry entry : entries) {
            if (result != null && ((Double)entry.getValue()).compareTo((Double)result.getValue()) <= 0) continue;
            result = entry;
        }
        if (result == null) {
            throw new MissingResultException(null);
        }
        return (String)result.getKey();
    }

    @Override
    public Double getConfidence(String value) {
        Type type = this.getType();
        if (!Type.CONFIDENCE.equals((Object)type)) {
            throw new EvaluationException();
        }
        return this.getFeature(value);
    }

    @Override
    public Double getProbability(String value) {
        Type type = this.getType();
        if (!Type.PROBABILITY.equals((Object)type)) {
            throw new EvaluationException();
        }
        return this.getFeature(value);
    }

    private Double getFeature(String value) {
        Double result = (Double)this.get(value);
        if (result == null) {
            result = 0.0;
        }
        return result;
    }

    void normalizeValues() {
        double sum = 0.0;
        Collection values = this.values();
        for (Double value : values) {
            sum += value.doubleValue();
        }
        Set entries = this.entrySet();
        for (Map.Entry entry : entries) {
            entry.setValue((Double)entry.getValue() / sum);
        }
    }

    public Type getType() {
        return this.type;
    }

    private void setType(Type type) {
        this.type = type;
    }

    public static enum Type {
        PROBABILITY,
        CONFIDENCE;

    }
}

