/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;

public abstract class EvaluationContext {
    private Deque<Map<FieldName, ?>> stack = Queues.newArrayDeque();

    public EvaluationContext() {
    }

    public EvaluationContext(Map<FieldName, ?> arguments) {
        this.pushFrame(arguments);
    }

    public abstract DerivedField resolveField(FieldName var1);

    public abstract DefineFunction resolveFunction(String var1);

    public Map<FieldName, ?> getArguments() {
        LinkedHashMap result = Maps.newLinkedHashMap();
        Deque<Map<FieldName, ?>> stack = this.getStack();
        Iterator<Map<FieldName, ?>> it = stack.descendingIterator();
        while (it.hasNext()) {
            Map<FieldName, ?> frame = it.next();
            result.putAll(frame);
        }
        return result;
    }

    public Object getArgument(FieldName name) {
        Deque<Map<FieldName, ?>> stack = this.getStack();
        for (Map<FieldName, ?> frame : stack) {
            if (!frame.containsKey(name)) continue;
            return frame.get(name);
        }
        return null;
    }

    public Map<FieldName, ?> popFrame() {
        return this.getStack().pop();
    }

    public void pushFrame(Map<FieldName, ?> frame) {
        this.getStack().push(frame);
    }

    Deque<Map<FieldName, ?>> getStack() {
        return this.stack;
    }
}

