/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.Row;
import org.jpmml.evaluator.ParameterUtil;
import org.w3c.dom.Element;

public class TableUtil {
    private TableUtil() {
    }

    public static List<Map<String, String>> parse(InlineTable table) {
        ArrayList result = Lists.newArrayList();
        List rows = table.getRows();
        for (Row row : rows) {
            LinkedHashMap map = Maps.newLinkedHashMap();
            List cells = row.getContent();
            for (Object cell : cells) {
                if (!(cell instanceof Element)) continue;
                Element element = (Element)cell;
                map.put(element.getTagName(), element.getTextContent());
            }
            result.add(map);
        }
        return Collections.unmodifiableList(result);
    }

    public static Map<String, String> match(List<Map<String, String>> rows, Map<String, ?> values) {
        block0: for (Map<String, String> row : rows) {
            if (values.size() < row.size() - 1) continue;
            Set<Map.Entry<String, ?>> entries = values.entrySet();
            for (Map.Entry<String, ?> entry : entries) {
                boolean equals;
                String rowValue = row.get(entry.getKey());
                if (rowValue != null && (equals = ParameterUtil.equals(entry.getValue(), rowValue))) continue;
                continue block0;
            }
            return row;
        }
        return null;
    }
}

