/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Apply;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FunctionUtil;
import org.jpmml.evaluator.PMMLManagerEvaluationContext;
import org.jpmml.evaluator.PMMLManagerTest;
import org.jpmml.manager.PMMLManager;
import org.junit.Assert;
import org.junit.Test;

public class DefineFunctionTest
extends PMMLManagerTest {
    @Test
    public void evaluateAmPm() throws Exception {
        PMMLManager pmmlManager = this.createManager();
        PMMLManagerEvaluationContext context = new PMMLManagerEvaluationContext(pmmlManager);
        Assert.assertEquals((Object)"AM", (Object)DefineFunctionTest.evaluateAmPm(34742, (EvaluationContext)context));
        Map<FieldName, Integer> arguments = Collections.singletonMap(new FieldName("StartTime"), 34742);
        Assert.assertEquals((Object)"AM", (Object)DefineFunctionTest.evaluateField(new FieldName("Shift"), arguments, (EvaluationContext)context));
    }

    @Test
    public void evaluateStategroup() throws Exception {
        PMMLManager pmmlManager = this.createManager();
        PMMLManagerEvaluationContext context = new PMMLManagerEvaluationContext(pmmlManager);
        Assert.assertEquals((Object)"West", (Object)DefineFunctionTest.evaluateStategroup("CA", (EvaluationContext)context));
        Assert.assertEquals((Object)"West", (Object)DefineFunctionTest.evaluateStategroup("OR", (EvaluationContext)context));
        Assert.assertEquals((Object)"East", (Object)DefineFunctionTest.evaluateStategroup("NC", (EvaluationContext)context));
        Map<FieldName, String> arguments = Collections.singletonMap(new FieldName("State"), "CA");
        Assert.assertEquals((Object)"West", (Object)DefineFunctionTest.evaluateField(new FieldName("Group"), arguments, (EvaluationContext)context));
    }

    private static Object evaluateAmPm(Integer time, EvaluationContext context) {
        return DefineFunctionTest.evaluateFunction("AMPM", Collections.singletonList(time), context);
    }

    private static Object evaluateStategroup(String state, EvaluationContext context) {
        return DefineFunctionTest.evaluateFunction("STATEGROUP", Collections.singletonList(state), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object evaluateField(FieldName name, Map<FieldName, ?> arguments, EvaluationContext context) {
        context.pushFrame(arguments);
        try {
            Object object = ExpressionUtil.evaluate((FieldName)name, (EvaluationContext)context);
            return object;
        }
        finally {
            context.popFrame();
        }
    }

    private static Object evaluateFunction(String function, List<?> values, EvaluationContext context) {
        Apply apply = new Apply(function);
        return FunctionUtil.evaluate((Apply)apply, values, (EvaluationContext)context);
    }
}

