/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.Array;
import org.dmg.pmml.DataType;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.ParameterUtil;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.UnsupportedFeatureException;

public class ArrayUtil {
    private ArrayUtil() {
    }

    public static Boolean isIn(Array array, Object value) {
        List<String> values = ArrayUtil.getContent(array);
        ArrayUtil.validateDataType(value);
        String stringValue = (String)ParameterUtil.cast(DataType.STRING, value);
        boolean result = values.contains(stringValue);
        return result;
    }

    public static Boolean isNotIn(Array array, Object value) {
        List<String> values = ArrayUtil.getContent(array);
        ArrayUtil.validateDataType(value);
        String stringValue = (String)ParameterUtil.cast(DataType.STRING, value);
        boolean result = !values.contains(stringValue);
        return result;
    }

    public static List<String> getContent(Array array) {
        List<String> parsedValue = array.getParsedValue();
        if (parsedValue == null) {
            parsedValue = ArrayUtil.tokenize(array);
            array.setParsedValue(parsedValue);
        }
        return parsedValue;
    }

    public static List<? extends Number> getNumberContent(Array array) {
        Array.Type type = array.getType();
        switch (type) {
            case INT: {
                return ArrayUtil.getIntContent(array);
            }
            case REAL: {
                return ArrayUtil.getRealContent(array);
            }
        }
        throw new EvaluationException();
    }

    public static List<Integer> getIntContent(Array array) {
        Function<String, Integer> transformer = new Function<String, Integer>(){

            public Integer apply(String string) {
                return Integer.valueOf(string);
            }
        };
        return Lists.transform(ArrayUtil.getContent(array), (Function)transformer);
    }

    public static List<Double> getRealContent(Array array) {
        Function<String, Double> transformer = new Function<String, Double>(){

            public Double apply(String string) {
                return Double.valueOf(string);
            }
        };
        return Lists.transform(ArrayUtil.getContent(array), (Function)transformer);
    }

    public static List<String> tokenize(Array array) {
        List<String> result;
        Array.Type type = array.getType();
        switch (type) {
            case INT: 
            case REAL: {
                result = ArrayUtil.tokenize(array.getValue(), false);
                break;
            }
            case STRING: {
                result = ArrayUtil.tokenize(array.getValue(), true);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)array, (Enum)type);
            }
        }
        Integer n = array.getN();
        if (n != null && ((Number)n).intValue() != result.size()) {
            throw new InvalidFeatureException((PMMLObject)array);
        }
        return result;
    }

    public static List<String> tokenize(String string, boolean enableQuotes) {
        ArrayList result = Lists.newArrayList();
        StringBuilder sb = new StringBuilder();
        boolean quoted = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (quoted) {
                if (c == '\\' && i < string.length() - 1) {
                    c = string.charAt(i + 1);
                    if (c == '\"') {
                        sb.append('\"');
                        ++i;
                        continue;
                    }
                    sb.append('\\');
                    continue;
                }
                sb.append(c);
                if (c != '\"') continue;
                result.add(ArrayUtil.createToken(sb, enableQuotes));
                quoted = false;
                continue;
            }
            if (c == '\"' && enableQuotes) {
                if (sb.length() > 0) {
                    result.add(ArrayUtil.createToken(sb, enableQuotes));
                }
                sb.append('\"');
                quoted = true;
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (sb.length() <= 0) continue;
                result.add(ArrayUtil.createToken(sb, enableQuotes));
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            result.add(ArrayUtil.createToken(sb, enableQuotes));
        }
        return Collections.unmodifiableList(result);
    }

    private static String createToken(StringBuilder sb, boolean enableQuotes) {
        String result = sb.length() > 1 && sb.charAt(0) == '\"' && sb.charAt(sb.length() - 1) == '\"' && enableQuotes ? sb.substring(1, sb.length() - 1) : sb.substring(0, sb.length());
        sb.setLength(0);
        return result;
    }

    private static void validateDataType(Object value) {
        DataType dataType = ParameterUtil.getDataType(value);
        switch (dataType) {
            case STRING: 
            case INTEGER: {
                break;
            }
            default: {
                throw new EvaluationException();
            }
        }
    }
}

