/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.Computable;

public class EvaluatorUtil {
    private EvaluatorUtil() {
    }

    public static Object decode(Object object) {
        if (object instanceof Computable) {
            Computable computable = (Computable)object;
            return computable.getResult();
        }
        return object;
    }

    public static Map<String, ?> decode(Map<FieldName, ?> map) {
        return EvaluatorUtil.decodeKeys(EvaluatorUtil.decodeValues(map));
    }

    public static <V> Map<FieldName, V> encodeKeys(Map<String, V> map) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        Set<Map.Entry<String, V>> entries = map.entrySet();
        for (Map.Entry entry : entries) {
            result.put(FieldName.create((String)((String)entry.getKey())), entry.getValue());
        }
        return result;
    }

    public static <V> Map<String, V> decodeKeys(Map<FieldName, V> map) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        Set<Map.Entry<FieldName, V>> entries = map.entrySet();
        for (Map.Entry entry : entries) {
            result.put(((FieldName)entry.getKey()).getValue(), entry.getValue());
        }
        return result;
    }

    public static <K> Map<K, ?> decodeValues(Map<K, ?> map) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        Set<Map.Entry<K, ?>> entries = map.entrySet();
        for (Map.Entry entry : entries) {
            result.put(entry.getKey(), EvaluatorUtil.decode(entry.getValue()));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static <K> List<Map<K, Object>> groupRows(K groupKey, List<Map<K, Object>> table) {
        LinkedHashMap groupedRows = Maps.newLinkedHashMap();
        for (int i = 0; i < table.size(); ++i) {
            Map<K, Object> row = table.get(i);
            Object groupValue = row.get(groupKey);
            ListMultimap listMultimap = (ListMultimap)groupedRows.get(groupValue);
            if (listMultimap == null) {
                ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
                groupedRows.put(groupValue, arrayListMultimap);
            }
            Set<Map.Entry<K, Object>> entries = row.entrySet();
            for (Map.Entry entry : entries) {
                void var6_7;
                Object key = entry.getKey();
                Object value = entry.getValue();
                var6_7.put(key, value);
            }
        }
        ArrayList resultTable = Lists.newArrayList();
        Set entries = groupedRows.entrySet();
        for (Map.Entry entry : entries) {
            LinkedHashMap resultRow = Maps.newLinkedHashMap();
            resultRow.putAll(((ListMultimap)entry.getValue()).asMap());
            resultRow.put(groupKey, entry.getKey());
            resultTable.add(resultRow);
        }
        return resultTable;
    }
}

