/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.AssociationModel;
import org.dmg.pmml.ClusteringModel;
import org.dmg.pmml.MiningModel;
import org.dmg.pmml.Model;
import org.dmg.pmml.NeuralNetwork;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.RegressionModel;
import org.dmg.pmml.RuleSetModel;
import org.dmg.pmml.Scorecard;
import org.dmg.pmml.TreeModel;
import org.jpmml.evaluator.AssociationModelEvaluator;
import org.jpmml.evaluator.ClusteringModelEvaluator;
import org.jpmml.evaluator.MiningModelEvaluator;
import org.jpmml.evaluator.NeuralNetworkEvaluator;
import org.jpmml.evaluator.RegressionModelEvaluator;
import org.jpmml.evaluator.RuleSetModelEvaluator;
import org.jpmml.evaluator.ScorecardEvaluator;
import org.jpmml.evaluator.TreeModelEvaluator;
import org.jpmml.manager.ModelManager;
import org.jpmml.manager.ModelManagerFactory;
import org.jpmml.manager.UnsupportedFeatureException;

public class ModelEvaluatorFactory
extends ModelManagerFactory {
    protected ModelEvaluatorFactory() {
    }

    public ModelManager<? extends Model> getModelManager(PMML pmml, Model model) {
        if (model instanceof AssociationModel) {
            return new AssociationModelEvaluator(pmml, (AssociationModel)model);
        }
        if (model instanceof ClusteringModel) {
            return new ClusteringModelEvaluator(pmml, (ClusteringModel)model);
        }
        if (model instanceof MiningModel) {
            return new MiningModelEvaluator(pmml, (MiningModel)model);
        }
        if (model instanceof NeuralNetwork) {
            return new NeuralNetworkEvaluator(pmml, (NeuralNetwork)model);
        }
        if (model instanceof RegressionModel) {
            return new RegressionModelEvaluator(pmml, (RegressionModel)model);
        }
        if (model instanceof RuleSetModel) {
            return new RuleSetModelEvaluator(pmml, (RuleSetModel)model);
        }
        if (model instanceof Scorecard) {
            return new ScorecardEvaluator(pmml, (Scorecard)model);
        }
        if (model instanceof TreeModel) {
            return new TreeModelEvaluator(pmml, (TreeModel)model);
        }
        throw new UnsupportedFeatureException((PMMLObject)model);
    }

    public static ModelEvaluatorFactory getInstance() {
        return new ModelEvaluatorFactory();
    }
}

